% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{rand_ortho_vector}
\alias{rand_ortho_vector}
\title{Get a random unit vector orthogonal to \code{u}.}
\usage{
rand_ortho_vector(u)
}
\arguments{
\item{u}{A unit vector.}
}
\value{
A random unit vector orthogonal to \code{u}.
}
\description{
Get a random unit vector orthogonal to \code{u}.
}
\note{
This function is stochastic. For reproducibility set a PRNG seed with
\link{set.seed}.
}
\examples{
r <- stats::runif(3)      # Get a random 3D vector
r <- r / norm(r, "2")     # Normalize it
o <- rand_ortho_vector(r) # Get a random unit vector orthogonal to r
r \%*\% o            # Check that r and o are orthogonal (result should be ~0)
}
