% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converter.R
\name{weighted_transitivity}
\alias{weighted_transitivity}
\title{Weighed transitivity of a weighted graph.}
\usage{
weighted_transitivity(g, upper_bound = NULL)
}
\arguments{
\item{g}{igraph graph}

\item{upper_bound}{upper bound to the edge weights used to compute the integral}
}
\value{
The weighted transitivity of the graph (a scalar).
}
\description{
Computed using the definition given by McAssey, M. P. and Bijma, F. in 
"A clustering coefficient for complete weighted networks" (2015).
}
\examples{
data(karate, package="igraphdata")
weighted_transitivity(karate)
}
\seealso{
Other cluster scoring functions: 
\code{\link{FOMD}()},
\code{\link{average_degree}()},
\code{\link{average_odf}()},
\code{\link{conductance}()},
\code{\link{coverage}()},
\code{\link{cut_ratio}()},
\code{\link{density_ratio}()},
\code{\link{edges_inside}()},
\code{\link{expansion}()},
\code{\link{internal_density}()},
\code{\link{max_odf}()},
\code{\link{normalized_cut}()},
\code{\link{scoring_functions}()},
\code{\link{weighted_clustering_coefficient}()}
}
\concept{cluster scoring functions}
