% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kclustcurv.R
\name{kclustcurv}
\alias{kclustcurv}
\title{k-groups of multiple curves}
\usage{
kclustcurv(y, x, z, weights = NULL, k, method = "survival",
  kbin = 50, h = -1, algorithm = "kmeans", seed = NULL)
}
\arguments{
\item{y}{Survival time (method = "survival") or response variable (method = "regression").}

\item{x}{Only for method = "regression". Dependent variable.}

\item{z}{Categorical variable indicating the population to which
the observations belongs.}

\item{weights}{Only for method = "survival". Censoring indicator of the survival
time of the process; 0 if the total time is censored and 1 otherwise.}

\item{k}{An integer specifying the number of groups of curves to be
performed.}

\item{method}{A character string specifying which method is used, "survival" or "regression".}

\item{kbin}{Size of the grid over which the survival functions
are to be estimated.}

\item{h}{The kernel bandwidth smoothing parameter (for method = "regression").}

\item{algorithm}{A character string specifying which clustering algorithm is used,
i.e., k-means(\code{"kmeans"}) or k-medians (\code{"kmedians"}).}

\item{seed}{Seed to be used in the procedure.}
}
\value{
A list containing the following items:
\item{measure}{A measure of...}
 \item{levels}{Original levels of the variable \code{fac}.}
 \item{cluster}{A vector of integers (from 1:k) indicating the cluster to
 which each curve is allocated.}
 \item{centers}{An object of class \code{survfit} containing the centroids
 (mean of the curves pertaining to the same group).}
 \item{curves}{An object of class \code{survfit} containing the survival
 curves for each population.}
}
\description{
Function for grouping survival or regression curves, given a number k,
based on the k-means or k-medians algorithm.
}
\examples{
library(clustcurv)
library(survival)
data(veteran)

# Survival: 2 groups k-means
s2 <- kclustcurv(y = veteran$time, weights = veteran$status,
z = veteran$celltype, k = 2, method = "survival", algorithm = "kmeans")

data.frame(level = s2$level, cluster = s2$cluster)


# Survival: 2 groups k-medians
s22 <- kclustcurv(y = veteran$time, weights = veteran$status,
z = veteran$celltype, k = 2, method = "survival", algorithm = "kmedians")

data.frame(level = s22$level, cluster = s22$cluster)


# Regression: 2 groups k-means
r2 <- kclustcurv(y = barnacle5$DW, x = barnacle5$RC,
z = barnacle5$F, k = 2, method = "regression", algorithm = "kmeans")

data.frame(level = r2$level, cluster = r2$cluster)



}
\author{
Nora M. Villanueva and Marta Sestelo.
}
