% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsys.r
\name{QSys}
\alias{QSys}
\title{Class for basic queuing system functions}
\description{
Provides the basic functions needed to communicate between machines
This should abstract most functions of rZMQ so the scheduler
implementations can rely on the higher level functionality
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{QSys$new()}}
\item \href{#method-submit_jobs}{\code{QSys$submit_jobs()}}
\item \href{#method-send_call}{\code{QSys$send_call()}}
\item \href{#method-set_common_data}{\code{QSys$set_common_data()}}
\item \href{#method-send_common_data}{\code{QSys$send_common_data()}}
\item \href{#method-send_job_data}{\code{QSys$send_job_data()}}
\item \href{#method-send_wait}{\code{QSys$send_wait()}}
\item \href{#method-receive_data}{\code{QSys$receive_data()}}
\item \href{#method-send_shutdown_worker}{\code{QSys$send_shutdown_worker()}}
\item \href{#method-cleanup}{\code{QSys$cleanup()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QSys$new(
  data = NULL,
  reuse = FALSE,
  ports = 6000:8000,
  master = NULL,
  node = host(),
  protocol = "tcp",
  template = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-submit_jobs"></a>}}
\subsection{Method \code{submit_jobs()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QSys$submit_jobs(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-send_call"></a>}}
\subsection{Method \code{send_call()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QSys$send_call(expr, env = list(), ref = substitute(expr))}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_common_data"></a>}}
\subsection{Method \code{set_common_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QSys$set_common_data(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-send_common_data"></a>}}
\subsection{Method \code{send_common_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QSys$send_common_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-send_job_data"></a>}}
\subsection{Method \code{send_job_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QSys$send_job_data(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-send_wait"></a>}}
\subsection{Method \code{send_wait()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QSys$send_wait(wait = 0.05 * self$workers_running)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive_data"></a>}}
\subsection{Method \code{receive_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QSys$receive_data(timeout = Inf, with_checks = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-send_shutdown_worker"></a>}}
\subsection{Method \code{send_shutdown_worker()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QSys$send_shutdown_worker()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cleanup"></a>}}
\subsection{Method \code{cleanup()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QSys$cleanup(quiet = FALSE, timeout = 5)}\if{html}{\out{</div>}}
}

}
}
