% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdls.R
\name{gdls}
\alias{gdls}
\title{Least squares with graident descent}
\usage{
gdls(A, b, alpha = 0.05, tol = 1e-06, m = 1e+05)
}
\arguments{
\item{A}{a square matrix representing the coefficients of a linear system}

\item{b}{a vector representing the right-hand side of the linear system}

\item{alpha}{the learning rate}

\item{tol}{the expected error tolerance}

\item{m}{the maximum number of iterations}
}
\value{
the modified matrix
}
\description{
Solve least squares with graident descent
}
\details{
\code{gdls} solves a linear system using gradient descent.
}
\examples{
head(b <- iris$Sepal.Length)
head(A <- matrix(cbind(1, iris$Sepal.Width, iris$Petal.Length, iris$Petal.Width), ncol = 4))
gdls(A, b, alpha = 0.05, m = 10000)

}
\seealso{
Other linear: \code{\link{choleskymatrix}},
  \code{\link{detmatrix}}, \code{\link{invmatrix}},
  \code{\link{iterativematrix}}, \code{\link{lumatrix}},
  \code{\link{refmatrix}}, \code{\link{rowops}},
  \code{\link{tridiagmatrix}}, \code{\link{vecnorm}}
}

