% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horner.R
\name{horner}
\alias{horner}
\alias{rhorner}
\alias{naivepoly}
\alias{betterpoly}
\title{Horner's rule}
\usage{
horner(x, coefs)

rhorner(x, coefs)

naivepoly(x, coefs)

betterpoly(x, coefs)
}
\arguments{
\item{x}{a vector of x values to evaluate the polynomial}

\item{coefs}{vector of coefficients of x}
}
\value{
the value of the function at \code{x}
}
\description{
Use Horner's rule to evaluate a polynomial
}
\details{
This function implements Horner's rule for fast polynomial
evaluation.  The implementation expects \code{x} to be a vector of x
values at which to evaluate the polynomial. The parameter \code{coefs}
is a vector of coefficients of \emph{x}.  The vector order is such
that the first element is the constant term, the second element is
the coefficient of \emph{x}, the so forth to the highest degreed
term.  Terms with a 0 coefficient should have a 0 element in the
vector.

The function \code{rhorner} implements the the Horner algorithm
recursively.

The function \code{naivepoly} implements a polynomial evaluator using
the straightforward algebraic approach.

The function \code{betterpoly} implements a polynomial evaluator using
the straightforward algebraic approach with cached \emph{x} terms.
}
\examples{
b <- c(2, 10, 11)
x <- 5
horner(x, b)
b <- c(-1, 0, 1)
x <- c(1, 2, 3, 4)
horner(x, b)
rhorner(x, b)
}
\seealso{
Other algebra: \code{\link{bilinear}},
  \code{\link{cubicspline}}, \code{\link{division}},
  \code{\link{fibonacci}}, \code{\link{isPrime}},
  \code{\link{linterp}}, \code{\link{nthroot}},
  \code{\link{polyinterp}}, \code{\link{pwiselinterp}},
  \code{\link{quadratic}}
}
\concept{algebra}
