% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmsaf.adjust.two.files.R
\name{cmsaf.adjust.two.files}
\alias{cmsaf.adjust.two.files}
\title{Routine to adjust the time dimensions and coordinates in two files.}
\usage{
cmsaf.adjust.two.files(
  var1,
  infile1,
  var2,
  infile2,
  outfile1,
  outfile2,
  nc34 = 4,
  overwrite = FALSE,
  verbose = FALSE,
  nc1 = NULL,
  nc2 = NULL
)
}
\arguments{
\item{var1}{Name of NetCDF variable of the first data set (character).}

\item{infile1}{Filename of first input NetCDF file. This may include the directory
(character).}

\item{var2}{Name of NetCDF variable of the second data set (character).}

\item{infile2}{Filename of second input NetCDF file. This may include the directory
(character).}

\item{outfile1}{Filename of first output NetCDF file. This may include the directory
(character).}

\item{outfile2}{Filename of second output NetCDF file. This may include the directory
(character).}

\item{nc34}{NetCDF version of output file. If \code{nc34 = 3} the output file will be
in NetCDFv3 format (numeric). Default output is NetCDFv4.}

\item{overwrite}{logical; should existing output file be overwritten?}

\item{verbose}{logical; if TRUE, progress messages are shown}

\item{nc1}{Alternatively to \code{infile1} you can specify the input as an
object of class \code{ncdf4} (as returned from \code{ncdf4::nc_open}).}

\item{nc2}{Alternatively to \code{infile2} you can specify the input as an
object of class \code{ncdf4} (as returned from \code{ncdf4::nc_open}).}
}
\value{
Two NetCDF files with the same time period and coordinate system are the result.
}
\description{
Designed for CM SAF R Toolbox.
}
