% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_survey.R
\name{gg_survey}
\alias{gg_survey}
\title{Plot voter shares observed in one survey}
\usage{
gg_survey(data, colors = NULL, labels = NULL, annotate_bars = TRUE, hurdle = 5)
}
\arguments{
\item{data}{Scraped dataset containing one row per party in the column
\code{party} and the observed voter share in the column \code{percent}}

\item{colors}{Named vector containing party colors. If \code{NULL}
(default) tries to guess color based on party names, gray otherwise.}

\item{labels}{Named vector containing party labels. If \code{NULL} (default)
tries to guess party names from \code{data}.}

\item{annotate_bars}{If \code{TRUE} (default) bars are annotated by the
respective vote share (percentage).}

\item{hurdle}{Hurdle for single parties to get into the parliament, e.g. '5'
for '5\%'. If set to NULL no horizontal line is plotted.
The horizontal line can be suppressed using \code{NULL}.}
}
\description{
Bar chart of the raw voter shares observed in one survey.
Additionally to plotting positive voter shares,
the function can be used to plot party-specific differences (e.g. between
a survey and the election result), including negative numbers.
}
\examples{
library(tidyr)
library(dplyr)
library(coalitions)

survey <- surveys_sample$surveys[[1]]$survey[[1]]

gg_survey(survey)
}
