% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seat-distribution.R
\name{redistribute}
\alias{redistribute}
\title{Calculate percentage of votes/seats after excluding parties with
\code{votes < hurdle}}
\usage{
redistribute(survey, hurdle = 0.05, others = "others", epsilon = 1e-05)
}
\arguments{
\item{survey}{The actual survey results on which \code{dirichlet.draws}
were based on.}

\item{hurdle}{The percentage threshold which has to be reached by a party
to enter the parliament. Any party called "ssw" will be exempt from the hurdle.}

\item{others}{A string indicating the name under which parties not listed
explicitly are subsumed.}

\item{epsilon}{Percentages should add up to 1. If they do not, within accuracy
of \code{epsilon}, an error is thrown.}
}
\description{
Calculate percentage of votes/seats after excluding parties with
\code{votes < hurdle}
}
\examples{
library(coalitions)
library(dplyr)
# get the latest survey for a sample of German federal election polls
surveys <- get_latest(surveys_sample)
# redistribute the shares of 'others' parties and parties with a share of under 5\\%
surveys <- surveys \%>\% mutate(survey_redist = purrr::map(survey, redistribute))
surveys$survey # results before redistribution
surveys$survey_redist # results after redistribution
}
\seealso{
\code{\link{get_seats}}, \code{\link{sls}}
}
