% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalition-probability.R
\name{get_probabilities}
\alias{get_probabilities}
\title{Wrapper for calculation of coalition probabilities from survey}
\usage{
get_probabilities(x, coalitions = list(c("cdu"), c("cdu", "fdp"), c("cdu",
  "fdp", "greens"), c("spd"), c("spd", "left"), c("spd", "left", "greens")),
  nsim = 1e+05, distrib.fun = sls, seats_majority = 300L,
  seed = as.numeric(now()), correction = NULL)
}
\arguments{
\item{x}{A table containing one row per survey and survey information in
long format in a separate column named \code{survey}.}

\item{coalitions}{A list of coalitions for which coalition probabilities should
be calculated. Each list entry must be a vector of party names. Those names
need to correspond to the names in \code{majority_df}.}

\item{nsim}{number of simulations}

\item{distrib.fun}{Function to calculate seat distribution. Defaults to
\code{\link{sls}} (Sainte-Lague/Schepers).}

\item{seats_majority}{The number of seats needed to obtain majority.}

\item{seed}{sets seed}

\item{correction}{A positive number. If not \code{NULL}, each sample from the
Dirichlet distribution will be additionally "corrected" by a random number
from U(-1*correction, 1*correction). This can be used to introduce extra
variation which might be useful due to rounding errors from reported survey
results (or add an additional source of variation in general).}
}
\description{
Wrapper for calculation of coalition probabilities from survey
}
\examples{
library(coalitions)
library(dplyr)
# get the latest survey for the sample German federal election polls
surveys <- get_latest(surveys_sample)
# calculate probabilities for two coalitions
probs <- get_probabilities(surveys,
                           coalitions = list(c("cdu", "fdp"),
                                             c("spd", "left", "greens")),
                           nsim = 100) # ensure fast runtime with only 100 simulations
probs \%>\% tidyr::unnest()
}
\seealso{
\code{\link[coalitions]{calculate_prob}}
}
