\name{bal.tab.list}
\alias{bal.tab.list}
\alias{bal.tab.formula.list}
\alias{bal.tab.df.list}
\title{
Balance Statistics for Data Sets
}
\description{
Generates balance statistics for unadjusted, matched, weighted, or stratified data using either a data frame or formula interface.
}
\usage{
\method{bal.tab}{list}(list_, 
    data, 
    treat.list = NULL, 
    weights = NULL, 
    int = FALSE, 
    distance.list = NULL, 
    addl.list = NULL, 
    method, 
    continuous = c("std", "raw"), 
    binary = c("raw", "std"), 
    s.d.denom, 
    m.threshold = NULL, 
    v.threshold = NULL, 
    ks.threshold = NULL, 
    r.threshold = NULL, 
    imbalanced.only = FALSE, 
    un = FALSE, 
    disp.bal.tab = TRUE, 
    disp.means = FALSE, 
    disp.v.ratio = FALSE, 
    disp.ks = FALSE, 
    pairwise = TRUE, 
    which.treat = NA, 
    multi.summary = TRUE, 
    which.time = NULL, 
    msm.summary = TRUE, 
    s.weights = NULL, 
    estimand = "ATE",
    quick = FALSE, 
    ...)
}
\arguments{
  \item{list_}{
Either a list of formulas with the treatment for each time period on the left and the covariates for which balance is to be displayed on the right, or a list of data frames containing all the covariates to be assessed at each time point. If formulas, an argument to \code{data} is required. If data frames, covariates to be assessed in multiple points must be included in the data frames for each time point. Data must be in the "wide" format, with one row per unit.
}
  \item{data}{
If \code{list_} is a list of data frames: Optional; a data frame containing variables with the names used in \code{treat.list}, \code{weights}, \code{distance.list}, and/or \code{addl.list}, if any.

If \code{list_} is a list of formulas: Required; a data frame containing all covariates named in the formulas and variables with the names used in the arguments mentioned above.
}
  \item{treat.list}{
Treatment status for each unit at each time point. This can be specified as a list or data frame of vectors, each of which contains the treatment status of each individual at each time point, or a list or vector of the names of variables in \code{data} that contain treatment at each time point.
}
  \item{weights}{
Optional; a vector, list, or data frame containing weights for each unit or a string containing the names of the weights variables in \code{data}. These can be weights generated by, e.g., inverse probability weighting. This must be specified in \code{method}. If \code{weights=NULL}, balance information will be presented only for the unadjusted sample.
}
  \item{int}{
\code{logical}; whether or not to include squares and 2-way interactions of covariates included in \code{list_} and in \code{addl.list}.
}
  \item{distance.list}{
Optional;  distance values (e.g., propensity scores) for each unit. These can be specified as a list of vectors or data frames containing the distance values (one for each time point), or as a single vector or data frame to be applied at all times points. The vectors or data frames can be replaced with the names of variables in \code{data} containing the distance values. If a list is used and some time points are not to have distance values, these can be replaced with NULL in the list.
}
  \item{addl.list}{
Optional; additional covariates for which to present balance.  These may be covariates included in the original dataset but not included in \code{list_}.  In general, it makes more sense to include all desired variables in \code{list_} than in \code{addl.list}. The arguments can be entered the same ways as those to \code{distance.list}.
}
  \item{method}{
A character vector containing the method of adjustement, if any. Currently only "weighting" is supported.
}
  \item{continuous}{
Whether mean differences for continuous variables should be standardized ("std") or raw ("raw").  Default "std".  Abbreviations allowed.
}
  \item{binary}{
Whether mean differences for binary variables (i.e., difference in proportion) should be standardized ("std") or raw ("raw").  Default "raw".  Abbreviations allowed.
}
  \item{s.d.denom}{
A character vector denoting whether the denominator for standardized differences (if any are calculated) should be the standard deviation of the treated group ("treated"), the standard deviation of the control group ("control"), or the pooled standard deviation ("pooled"), computed as the square root of the mean of the group variances. Abbreviations allowed. If weights are supplied, each set of weights should have a corresponding entry to \code{s.d.denom}. If left blank and weights are supplied, \code{bal.tab()} will try to determine whether the ATT, ATC, or ATE is being estimated based on the pattern of weights and supply \code{s.d.denom} accordingly. If left blank, \code{bal.tab()} will try to use the \code{estimand} argument. It is recommended not to set this argument for longitudinal treatments.
}
  \item{m.threshold}{
A numeric value for the threshold for mean differences.  .1 is recommended.  
}
  \item{v.threshold}{
A numeric value for the threshold for variance ratios.  Will automatically convert to the inverse if less than 1.
}
  \item{ks.threshold}{
A numeric value for the threshold for Kolmogorov-Smirnov statistics. Must be between 0 and 1. 
}
  \item{r.threshold}{
A numeric value for the threshold for correlations between covariates and treatment when treatment is continuous.
}
  \item{imbalanced.only}{
\code{logical}; whether to display only the covariates that failed to meet at least one of balance thresholds.
}
  \item{un}{
\code{logical}; whether to print statistics for the unadjusted sample as well as for the adjusted sample.
}
  \item{disp.bal.tab}{
\code{logical}; whether to display the table of balance statistics.
}
  \item{disp.means}{
\code{logical}; whether to print the group means in balance output.
}
  \item{disp.v.ratio}{
\code{logical}; whether to display variance ratios in balance output.
}
  \item{disp.ks}{
\code{logical}; whether to display Kolmogorov-Smirnov statistics in balance output.
}
  \item{pairwise}{
Whether balance should be computed for pairs of treatments or for each treatment against all others combined when treatment is multinomial. See \code{\link{bal.tab.multi}} for details. 
}
  \item{which.treat}{
Which treatments to display when multinomial treatments are used. See \code{\link{bal.tab.multi}} for details.
}
  \item{multi.summary}{
\code{logical}; whether to display the balance summary table across pairwise comparisons when multinomial treatments are used. See \code{\link{bal.tab.multi}} for details.
}
  \item{which.time}{
Which time periods to display if longutdinal treatments are used. See \code{\link{bal.tab.msm}} for details.
}
  \item{msm.summary}{
\code{logical}; whether to display the balance summary table across time periods when longitudinal treatments are used. See \code{\link{bal.tab.msm}} for details.
}
  \item{s.weights}{
Optional; either a vector containing sampling weights for each unit or a string containing the name of the sampling weight variable in \code{data}. These function like regular weights except that both the adjusted and unadjusted samples will be weighted according to these weights if weights are used.
}
  \item{estimand}{
The causal estimand of interest. This value is used to set \code{s.d.denom}, and should not be changed from "ATE".
}
  \item{quick}{
\code{logical}; if \code{TRUE}, will not compute any values that will not be displayed. Leave \code{FALSE} if computed values not displayed will be used later.
}
  \item{...}{
Ignored.
}
}
\details{
\code{bal.tab.list()} generates a list of balance summaries for each time point based on the treatments and covariates provided. All data must be in the "wide" format, with exactly one row per unit and columns representing variables at different time points. See the \code{\link[WeightIt]{weightitMSM}} documentation for an example of how to transform long data into wide data using \code{\link{reshape}}. 

All balance statistics are calculated whether they are displayed by print or not, unless \code{quick = TRUE}.  The threshold values (\code{m.threshold}, \code{v.threshold}, \code{ks.threshold}, and \code{r.threshold}) control whether extra columns should be inserted into the Balance table describing whether the balance statistics in question exceeded or were within the threshold.  Including these thresholds also creates summary tables tallying the number of variables that exceeded and were within the threshold and displaying the variables with the greatest imbalance on that balance measure.  When subclassification is used, the extra threshold columns are placed within the balance tables for each subclass as well as in the aggregate balance table, and the summary tables display balance for each subclass.

Multiple sets of weights can be supplied simultaneously by incuding entering a data frame or a character vector containing the names of weight variables found in \code{data} or a list thereof. The arguments to \code{method}, \code{s.d.denom}, and \code{estimand}, if any, must be either the same length as the number of sets of weights or of length one, where the sole entry is applied to all sets. When standardized differences are computed for the unadjusted group, they are done using the first entry to \code{s.d.denom} or \code{estimand}. When only one set of weights is supplied, the output for the adjusted group will simply be called \code{"Adj"}, but otherwise will be named after each corresponding set of weights. Specifying mutliple sets of weights will also add components to other output of \code{bal.tab()}.

}
\value{
An object of class \code{bal.tab.msm} containing balance summaries at each time point. Each balance summary is its own \code{bal.tab} object. See \code{\link{bal.tab.msm}} for more details.

Currently, clusters and multiply imputated data are not compatible with longitudinal treatments.

See \code{\link[=bal.tab.formula]{bal.tab base methods}} for more detailed information on the value of the \code{bal.tab} objects produced for each time point.
}


\author{
Noah Greifer 
}

\seealso{
\code{\link[=bal.tab.formula]{bal.tab base methods}} for details of calculations.

\code{\link{bal.tab.msm}} for output and relaed options.

}
\examples{
data("iptwExWide", package = "twang")
library("cobalt")

## Estimating longtiduinal propensity scores and weights
ps1 <- glm(tx1 ~ age + gender + use0,
            data = iptwExWide, 
            family = "binomial")$fitted.values
w1 <- ifelse(iptwExWide$tx1 == 1, 1/ps1, 1/(1-ps1))
ps2 <- glm(tx2 ~ age + gender + use0 + tx1 + use1,
            data = iptwExWide, 
            family = "binomial")$fitted.values
w2 <- ifelse(iptwExWide$tx2 == 1, 1/ps2, 1/(1-ps2))
ps3 <- glm(tx3 ~ age + gender + use0 + tx1 + use1 + tx2 + use2,
            data = iptwExWide, 
            family = "binomial")$fitted.values
w3 <- ifelse(iptwExWide$tx3 == 1, 1/ps3, 1/(1-ps3))
                     
w <- w1*w2*w3

# data frame interface:
bal.tab(list(iptwExWide[c("use0", "gender")],
             iptwExWide[c("use0", "gender", "use1", "tx1")],
             iptwExWide[c("use0", "gender", "use1", "tx1", "use2", "tx2")]),
        treat.list = iptwExWide[c("tx1", "tx2", "tx3")], 
        weights = w,
        distance.list = list(ps1, ps2, ps3),
        addl.list = iptwExWide["age"],
        un = TRUE)

# Formula interface:
bal.tab(list(tx1 ~ use0 + gender,
             tx2 ~ use0 + gender + use1 + tx1,
             tx3 ~ use0 + gender + use1 + tx1 + use2 + tx2),
        data = iptwExWide, 
        weights = w,
        distance.list = list(ps1, ps2, ps3),
        addl.list = "age",
        un = TRUE)
}
