% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_stats.R
\name{format_stats.BFBayesFactor}
\alias{format_stats.BFBayesFactor}
\title{Format Bayes factors}
\usage{
\method{format_stats}{BFBayesFactor}(
  x,
  digits1 = 1,
  digits2 = 2,
  cutoff = NULL,
  label = "BF",
  italics = TRUE,
  subscript = "10",
  type = "md",
  ...
)
}
\arguments{
\item{x}{BayesFactor object or vector of numeric Bayes factor values}

\item{digits1}{Number of digits after the decimal for Bayes factors > 1}

\item{digits2}{Number of digits after the decimal for Bayes factors < 1}

\item{cutoff}{Cutoff for using \verb{_BF_~10~ > <cutoff>} or
\verb{_BF_~10~ < 1 / <cutoff>} (value must be > 1)}

\item{label}{Character string for label before Bayes factor. Default is BF.
Set \code{label = ""} to return just the formatted Bayes factor value with no
label or operator (\code{=}, \code{<}, \code{>})}

\item{italics}{Logical value (default = TRUE) for whether label should be
italicized (\emph{BF} or BF)}

\item{subscript}{Subscript to include with \emph{BF} label (\code{"10"}, \code{"01"}, or
\code{""} for no subscript)}

\item{type}{Type of formatting (\code{"md"} = markdown, \code{"latex"} = LaTeX)}

\item{...}{Additional arguments passed to methods.}
}
\value{
A character string of statistical information formatted in Markdown or LaTeX.
}
\description{
This method formats Bayes factors from the
\{\href{https://cran.r-project.org/package=BayesFactor}{BayesFactor}\} package.
By default, this function rounds Bayes factors greater than 1 to one decimal
place and Bayes factors less than 1 to two decimal places. Values greater
than 1000 or less than 1/1000 are formatted using scientific notation.
Cutoffs can be set that format the values as greater than or less than the
cutoffs (e.g., BF > 1000 or BF < 0.001). Numbers of digits, cutoffs,
italics, and label subscripts are all customizable.
}
\examples{
# Prepare statistical object
test_bf <- BayesFactor::ttestBF(mtcars$vs, mtcars$am)

# Format Bayes factor
format_stats(test_bf)

# Control cutoff for output
format_stats(test_bf, cutoff = 3)

# Change digits, remove italics and subscript
format_stats(test_bf, digits2 = 1, italics = FALSE, subscript = "")

# Return only Bayes factor value (no label)
format_stats(test_bf, label = "")

# Format for LaTeX
format_stats(test_bf, type = "latex")
}
\seealso{
Other functions for printing statistical objects: 
\code{\link{format_bf}()},
\code{\link{format_corr}()},
\code{\link{format_stats}()},
\code{\link{format_stats.easycorrelation}()},
\code{\link{format_stats.htest}()},
\code{\link{format_ttest}()}
}
\concept{functions for printing statistical objects}
