## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(coda.base)

## -----------------------------------------------------------------------------
nP = 6
nO = 8
set.seed(1)
X = matrix(rlnorm(nP * nO), ncol = nP, nrow = nO)
colnames(X) = paste0('P', 1:nP)
rownames(X) = paste0('O', 1:nO)
X

## -----------------------------------------------------------------------------
center(X)

## -----------------------------------------------------------------------------
variation_array(X)

## -----------------------------------------------------------------------------
dist(X, method = 'aitchison')

## -----------------------------------------------------------------------------
coordinates(X)

## -----------------------------------------------------------------------------
ilr_basis(nP)

## -----------------------------------------------------------------------------
all.equal(as.numeric(coordinates(X, 'ilr')),
          as.numeric(log(X) %*% ilr_basis(nP)))

