% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda4microbiome_functions.R
\name{plot_prediction}
\alias{plot_prediction}
\title{plot_prediction}
\usage{
plot_prediction(prediction, y, strata = NULL, showPlots = TRUE)
}
\arguments{
\item{prediction}{the fitted values of predictions for the model}

\item{y}{outcome (binary or continuous); data type: numeric, character or factor vector}

\item{strata}{stratification variable (default = NULL)}

\item{showPlots}{if TRUE, shows the plots (default = TRUE)}
}
\value{
prediction plot
}
\description{
Plot of the predictions of a fitted model:
Multiple box-plot and density plots for binary outcomes and Regression plot for continuous outcome
}
\examples{

# prediction plot for the log-ratio between columns 3 and 32 on HIV status

data(HIV, package = "coda4microbiome")

x<-impute_zeros(x_HIV)

lr<-log(x[,3])-log(x[,32])

plot_prediction(lr, y_HIV)


}
\author{
M. Calle - T. Susin
}
