% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codyn-package.R
\docType{data}
\name{pplots}
\alias{pplots}
\title{Phosphorus plots data from Avolio et al. 2014}
\format{
A data frame with 1232 rows and 6 variables
}
\source{
Avolio, ML, Koerner, S, La Pierre, K, Wilcox, K, Wilson, GTW, Smith, MD, Collins, S. 2014. Changes in plant community composition, not diversity, to a decade of nitrogen and phosphorus additions drive changes in aboveground productivity in a tallgrass prairie. Journal of Ecology. 102: 1649-1660.
}
\usage{
data(pplots)
}
\description{
A dataset of tallgrass prairie plant composition in a nitrogen and phosphorus addition experiment at Konza Prairie, Manhattan Kansas (Avolio et al. 2014). This dataset is a subset of the full dataset.
}
\details{
A data frame containing a column for replicate, year, species, abundance, block and treatment :
\itemize{
  \item plot: An integer column of spatial replicates with 18 levels (6-48)
  \item year: An integer column of sampling time points
  \item species: A factor column of species sampled
  \item relative_cover: A numeric column of relative cover values
  \item block: An integer column of dummy blocking variable, grouping treatment plots into blocks
  \item treatment: A factor column of nitrogen and phosphorus treatments applied to the plots
}
}
\keyword{datasets}
