% Generated by roxygen2 (4.0.1): do not edit by hand
\name{expand}
\alias{expand}
\title{An \code{expand.grid}-like function that repeats sets of
vectors for every value in a reference vector.}
\usage{
expand(x, ...)
}
\arguments{
\item{x}{numeric; vector of data points which are to be replicated
for each of the sets of vectors supplied to \code{...}.}

\item{...}{additional vector arguments to be expanded to the correct
length. These are taken to be a set of values to be replicated for
each of the elements of \code{x}.}
}
\value{
a matrix of replicated vectors, with column names for \code{x}
and named arguments passed as \code{...}.
}
\description{
The values of \code{x} are repeated for each combination
of elements in the vectors supplied via \code{...}, with the first
elements of each vector in \code{...} being taken as a set, the
second elements as another set, and so on. \code{x} is repeated for
each of these sets.
}
\examples{
# Recreate Fig. 2 of Minchin (1987)
# Parameters for each of 6 six species
A0 <- c(5,4,7,5,9,8) * 10
m <- c(25,85,10,60,45,60)
r <- c(3,3,4,4,6,5) * 10
alpha <- c(0.1,1,2,4,1.5,1)
gamma <- c(0.1,1,2,4,0.5,4)
# Gradient locations
x <- 1:100

# expand parameter set
pars <- expand(x, m = m, A0 = A0, r = r, alpha = alpha,
               gamma = gamma)
head(pars)
}
\author{
Gavin L. Simpson
}
\references{
Minchin P.R. (1987) Simulation of multidimensional
community patterns: towards a comprehensive model. \emph{Vegetatio}
\strong{71}, 145--156.
}
\keyword{utilities}

