% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/dprcoga.R
\name{dcoga}
\alias{dcoga}
\alias{pcoga}
\alias{rcoga}
\title{Convolution of Gamma Distributions (Exact Method).}
\usage{
dcoga(x, shape, rate)

pcoga(x, shape, rate)

rcoga(n, shape, rate)
}
\arguments{
\item{x}{Quantiles.}

\item{shape}{Numerical vector of shape parameters for each gamma distributions,
all shape parameters should be larger than or equal to 0, with at least one
non-zero.}

\item{rate}{Numerical vector of rate parameters for each gamma distributions,
all rate parameters should be larger than 0.}

\item{n}{Number of sample points.}
}
\description{
Density, distribution function, and random generation for convolution
of gamma distributions. Convolution of independent Gamma random
variables is \eqn{Y = X_{1} + ... + X_{n}}, where \eqn{X_{i}, i = 1, ..., n},
are independent Gamma distributions with parameters shapes and rates.
The exact density function and distribution function can be calculated,
according to the formulas from Moschopoulos, Peter G. (1985).
**We mention that \code{dcoga} and \code{pcoga} are recommended
for \eqn{n >= 3}.**
}
\examples{
## Example 1: Correctness check
set.seed(123)
## do grid
y <- rcoga(100000, c(3,4,5), c(2,3,4))
grid <- seq(0, 15, length.out=100)
## calculate pdf and cdf
pdf <- dcoga(grid, shape=c(3,4,5), rate=c(2,3,4))
cdf <- pcoga(grid, shape=c(3,4,5), rate=c(2,3,4))

## plot pdf
plot(density(y), col="blue")
lines(grid, pdf, col="red")

## plot cdf
plot(ecdf(y), col="blue")
lines(grid, cdf, col="red")

## Example 2: Show parameter recycling
## these pairs give us the same results
dcoga(1:5, c(1, 2), c(1, 3, 4, 2, 5))
dcoga(1:5, c(1, 2, 1, 2, 1), c(1, 3, 4, 2, 5))

pcoga(1:5, c(1, 3, 5, 2, 2), c(3, 5))
pcoga(1:5, c(1, 3, 5, 2, 2), c(3, 5, 3, 5, 3))

}
\references{
Moschopoulos, Peter G. "The distribution of the sum of independent
gamma random variables." Annals of the Institute of
Statistical Mathematics 37.1 (1985): 541-544.
}
\author{
Chaoran Hu
}
