% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_contour.r
\name{draw_contour}
\alias{draw_contour}
\title{Visualize Contour-Based Region and Center of Gravity (COG)}
\usage{
draw_contour(lst, show_cog = TRUE, plot_image = TRUE)
}
\arguments{
\item{lst}{A list returned by \code{\link{cog_contour}}, containing
a data frame of polygon points and computed statistics.}

\item{show_cog}{Logical. If \code{TRUE} (default), draws horizontal and vertical
red lines through the COG to indicate its location.}

\item{plot_image}{Logical. If \code{TRUE} (default), plots the reconstructed image. If \code{FALSE},
returns the image object without displaying it.}
}
\value{
An object of class \code{cimg} representing the polygon-filled image
(with or without COG lines), which can be further used or saved.
}
\description{
Visualizes the character region enclosed by the convex polygon computed using \code{\link{cog_contour}}.
Optionally overlays crosshair lines at the computed center of gravity (COG) to aid interpretation.
}
\examples{
\dontshow{if ((identical(Sys.getenv("IN_PKGDOWN"), "true") || interactive())) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(img_A) # load example image from the package
result <- cog_contour(img_A)
draw_contour(result, show_cog = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{cog_contour}}
}
