% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr.R
\name{coordCMap}
\alias{coordCMap}
\title{Coordinates of the vertices of a Cognitive Map}
\usage{
coordCMap(soc.cmap, layoutType = "neato")
}
\arguments{
\item{soc.cmap}{An object of class SocCMap, as an output of the SocCMap function}

\item{layoutType}{Type of graph. See detail in RGraphViz. Can be 'neato', 'dot', 'twopi', 'circo', and 'fdp'. The default is 'neato'.}
}
\value{
A data frame with three variable :
\describe{
\item{$vertex}{The number of the vertex)}
\item{$x}{The x coordinate of the vertex}
\item{$y}{The y coordinate of the vertex}
}
}
\description{
Get the coordinates of the vertices of a Cognitive Map. The output of this function can be useful for plotting Cognitive Maps in a personalize ways (as with ggplot2 as done by the ggCMap function of this package)
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

edg.scm <- EdgSocCMap(my.project, min.weight=6, weighted.icm=TRUE)

scm <- SocCMap(edg.scm, my.project, label = "name", shape = "plaintext")
coordCMap(scm)
}
