% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-report.R
\name{ReportSCM}
\alias{ReportSCM}
\title{Create a serie of reports on Individual Cognitive Maps and quotes}
\usage{
ReportSCM(project, min.weight = 1, filters = NULL, units = "all",
  weighted.icm = FALSE, format = "html", output_dir = tempdir())
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{min.weight}{A integer that will determine the minimum (>=) weight of relationships that will be taken into account. Relationships with a lower weight (<) will not be shown. Default is set to 1 (\emph{i.e.} all relationships are shown).}

\item{filters}{A list of named strings that will filter the relationships showed in the SCM. e.g. =list(coding_class = "A_coding_class", document_part = "A_document_part")=. To date, these filters are linked to the nature of relationships.}

\item{units}{A string vector giving the names of the units (i.e. classes linked to documents) that will be include in the SCM. It is a second type of filter.}

\item{weighted.icm}{A boolean. If FALSE, the weight of the relationships in the ICM will be fixed to 1.}

\item{format}{A character string, the format of the report you want. 'html' (default), 'pdf'.}

\item{output_dir}{A character string, the output directory of the rendered file (see rmarkdown::render())}
}
\value{
A cute message.
}
\description{
Create a serie of reports on Social Cognitive Maps and quotes
}
\details{
Create a serie of reports on Social Cognitive Maps and quotes. The 'pdf' format will depend on a LaTeX installation. The reports will be stored in a subfolder of your working directory ('./data-output/icm/...').
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

ReportSCM(my.project)
ReportSCM(my.project, units = "Farmer")
## pdf : need LaTeX to be installed and working with R.
## ReportSCM(my.project, min.weight = 3, format = "pdf")
}
