% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exchanges.R
\name{get_exchange_map}
\alias{get_exchange_map}
\title{Get all cryptocurrency exchanges}
\usage{
get_exchange_map(...)
}
\arguments{
\item{...}{Further arguments passed to the request. Further information
can be found in the \href{https://coinmarketcap.com/api/documentation/v1/#operation}{API documentation}}
}
\value{
A dataframe with exchange values
}
\description{
Returns a paginated list of all cryptocurrency exchanges by CoinMarketCap ID.
We recommend using this convenience endpoint to lookup and utilize our unique
exchange id across all endpoints as typical exchange identifiers may change
over time. As a convenience you may pass a comma-separated list of exchanges
by slug to filter this list to only those you require.
}
\examples{
\dontrun{
get_exchange_map()
get_exchange_map(listing_status = "inactive",
                 slug = "binance", start = 5, limit = 100)
}
}
\references{
\href{https://coinmarketcap.com/api/documentation/v1/#operation/getV1ExchangeMap}{API documentation}
}
\seealso{
Other Exchanges: 
\code{\link{get_exchange_meta}()}
}
\concept{Exchanges}
