% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{get_price_conversion}
\alias{get_price_conversion}
\title{Price Conversion}
\usage{
get_price_conversion(amount = NULL, id, symbol, time, convert, convert_id)
}
\arguments{
\item{amount}{An amount of currency to convert. Example: 10.43}

\item{id}{The CoinMarketCap currency ID of the base cryptocurrency or fiat to convert from.
If \code{id} and \code{symbol} are both missing or NULL, `BTC` is set as default symbol.}

\item{symbol}{Alternatively the currency symbol of the base cryptocurrency or fiat to convert from.
One \code{id} or \code{symbol} is required.}

\item{time}{Optional timestamp to reference historical pricing during conversion.
If not passed, the current time will be used. If passed, we'll reference the closest historic
values available for this conversion.}

\item{convert}{Pass up to 120 comma-separated fiat or cryptocurrency symbols to convert
the source amount to. Default is `USD`.}

\item{convert_id}{Optionally calculate market quotes by CoinMarketCap ID instead of symbol.
This option is identical to convert outside of ID format. Ex: convert_id=1,2781 would
replace convert=BTC,USD in your query. This parameter cannot be used when convert is used.}
}
\value{
A dataframe with price conversion information
}
\description{
Convert an amount of one cryptocurrency or fiat currency into one or more different currencies
utilizing the latest market rate for each currency. You may optionally pass a historical
timestamp as time to convert values based on historical rates (as your API plan supports).
}
\details{
Cache / Update frequency:Every 60 seconds for the lastest cryptocurrency and fiat currency rates.
Plan credit use: 1 call credit per call and 1 call credit per convert option beyond the first.
CMC equivalent pages: Our cryptocurrency conversion page at \href{https://coinmarketcap.com/converter/}{converter}.
}
\examples{
\dontrun{
get_price_conversion(1)
get_price_conversion(amount = 1, symbol = "BTC", convert = c("EUR","LTC","USD"))
get_price_conversion(amount = 1, id=1, time = Sys.Date()-100)
}
}
\references{
\href{https://coinmarketcap.com/api/documentation/v1/#tag/tools}{API documentation}
}
\concept{Tools}
