context("fmedian")

x <- rnorm(100)
xNA <- x
xNA[sample.int(100,20)] <- NA
f <- as.factor(sample.int(10, 100, TRUE))
g <- GRP(mtcars, ~ cyl + vs + am)
mtcNA <- na_insert(mtcars)
mtcNA[27,1] <- NA # single group NA !!
m <- as.matrix(mtcars)
mNA <- as.matrix(mtcNA)
mNAc <- mNA
storage.mode(mNAc) <- "character"


test_that("fmedian performs like base::median", {
  expect_equal(fmedian(NA), as.double(median(NA)))
  expect_equal(fmedian(NA, na.rm = FALSE), as.double(median(NA)))
  expect_equal(fmedian(1), median(1, na.rm = TRUE))
  expect_equal(fmedian(1:3), median(1:3, na.rm = TRUE))
  expect_equal(fmedian(-1:1), median(-1:1, na.rm = TRUE))
  expect_equal(fmedian(1, na.rm = FALSE), median(1))
  expect_equal(fmedian(1:3, na.rm = FALSE), median(1:3))
  expect_equal(fmedian(-1:1, na.rm = FALSE), median(-1:1))
  expect_equal(fmedian(x), median(x, na.rm = TRUE))
  expect_equal(fmedian(x, na.rm = FALSE), median(x))
  expect_equal(fmedian(xNA, na.rm = FALSE), median(xNA))
  expect_equal(fmedian(xNA), median(xNA, na.rm = TRUE))
  expect_equal(fmedian(mtcars), fmedian(m))
  expect_equal(fmedian(m), dapply(m, median, na.rm = TRUE))
  expect_equal(fmedian(m, na.rm = FALSE), dapply(m, median))
  expect_equal(fmedian(mNA, na.rm = FALSE), dapply(mNA, median))
  expect_equal(fmedian(mNA), dapply(mNA, median, na.rm = TRUE))
  expect_equal(fmedian(x, f), BY(x, f, median, na.rm = TRUE))
  expect_equal(fmedian(x, f, na.rm = FALSE), BY(x, f, median))
  expect_equal(fmedian(xNA, f, na.rm = FALSE), BY(xNA, f, median))
  expect_equal(fmedian(xNA, f), BY(xNA, f, median, na.rm = TRUE))
  expect_equal(fmedian(m, g), BY(m, g, median, na.rm = TRUE))
  expect_equal(fmedian(m, g, na.rm = FALSE), BY(m, g, median))
  expect_equal(fmedian(mNA, g, na.rm = FALSE), BY(mNA, g, median))
  expect_equal(fmedian(mNA, g), BY(mNA, g, median, na.rm = TRUE))
  expect_equal(fmedian(mtcars, g), BY(mtcars, g, median, na.rm = TRUE))
  expect_equal(fmedian(mtcars, g, na.rm = FALSE), BY(mtcars, g, median))
  expect_equal(fmedian(mtcNA, g, na.rm = FALSE), BY(mtcNA, g, median))
  expect_equal(fmedian(mtcNA, g), BY(mtcNA, g, median, na.rm = TRUE))
})

test_that("fmedian performs numerically stable", {
  expect_true(all_obj_equal(replicate(50, fmedian(1), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(NA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(NA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(x), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(x, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(xNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(xNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(m), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(m, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(mNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(mNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(mtcars), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(mtcars, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(mtcNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(mtcNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(x, f), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(x, f, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(xNA, f, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(xNA, f), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(m, g), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(m, g, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(mNA, g, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(mNA, g), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(mtcars, g), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(mtcars, g, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(mtcNA, g, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmedian(mtcNA, g), simplify = FALSE)))
})

test_that("fmedian handles special values in the right way", {
  expect_equal(fmedian(NA), NA_real_)
  expect_equal(fmedian(NaN), NaN)
  expect_equal(fmedian(Inf), Inf)
  expect_equal(fmedian(-Inf), -Inf)
  expect_equal(fmedian(TRUE), 1)
  expect_equal(fmedian(FALSE), 0)
  expect_equal(fmedian(NA, na.rm = FALSE), NA_real_)
  expect_equal(fmedian(NaN, na.rm = FALSE), NaN)
  expect_equal(fmedian(Inf, na.rm = FALSE), Inf)
  expect_equal(fmedian(-Inf, na.rm = FALSE), -Inf)
  expect_equal(fmedian(TRUE, na.rm = FALSE), 1)
  expect_equal(fmedian(FALSE, na.rm = FALSE), 0)
})

test_that("fmedian produces errors for wrong input", {
  expect_error(fmedian("a"))
  expect_error(fmedian(NA_character_))
  expect_error(fmedian(mNAc))
  expect_error(fmedian(mNAc, f))
  expect_error(fmedian(1:2,1:3))
  expect_error(fmedian(m,1:31))
  expect_error(fmedian(mtcars,1:31))
  expect_error(fmedian(wlddev))
  expect_error(fmedian(wlddev, wlddev$iso3c))
})
