% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dict.R
\docType{data}
\name{Dict}
\alias{Dict}
\title{Dictionary}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Dict
}
\description{
The \code{Dict} class creates an ordinary (unordered) dictionary.
The key-value pairs are stored in an R environment.
}
\section{Usage}{

\preformatted{
Dict$new()
Dict$set(key, value)
Dict$get(key, default = NULL)
Dict$remove(key)
Dict$pop(key, default = NULL)
Dict$has(key)
Dict$keys()
Dict$values()
Dict$update(d)
Dict$clear()
Dict$size()
Dict$as_list()
}


\itemize{
\item \code{key}: any R object, key of the item
\item \code{value}: any R object, value of the item
\item \code{default}: optional, the default value of an item if the key is not found
}
}

\examples{
d <- Dict$new()
d$set("apple", 5)
d$set("orange", 10)
d$set("banana", 3)
d$get("apple")
d$as_list()  # unordered
d$pop("orange")
d$as_list()  # "orange" is removed
}
\seealso{
\link{OrderedDict} and \link{OrderedDictL}
}
\keyword{datasets}
