% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_smes_domains}
\alias{get_smes_domains}
\title{Calculate the prioritized list of domains for a given subject matter expert (SME)}
\usage{
get_smes_domains(sme, questions)
}
\arguments{
\item{sme}{Name of the subject matter expert.}

\item{questions}{A \code{\link{tidyrisk_question_set}} object.}
}
\value{
An ordered vector of the domains for the requested SME.
}
\description{
Given a tidyrisk_question_set object and the name and the name of a specific SME of
  interest, create a vector of the domains in order of priority.
}
\examples{
\dontrun{
questions <- read_questions()
get_sme_domains("Sally Expert", questions)
}
}
