% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_slides.R
\name{make_slides}
\alias{make_slides}
\title{Create interview slides}
\usage{
make_slides(
  sme,
  questions,
  output_dir,
  assessment_title = "Strategic Risk Assessment"
)
}
\arguments{
\item{sme}{Name of the SME being interviewed.}

\item{questions}{A \code{\link{tidyrisk_question_set}} object.}

\item{output_dir}{Directory location for knitted slides.}

\item{assessment_title}{Title of the assessment being performed.}
}
\value{
Invisibly returns the full path to the slide file.
}
\description{
Creates an in-browser slideshow as a visual aide when conducting an
interview with a subject matter expert (SME). The slideshow is customized
for the SME by placing the domains in the order of preference for that
SME.
}
\examples{
\dontrun{
make_slides("Sally Expert", questions, output_dir = tempdir())
}
}
