% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order_methods.R
\name{f_v_rf_categorical}
\alias{f_v_rf_categorical}
\title{Association Between a Categorical Response and a Categorical or Numeric Predictor}
\usage{
f_v_rf_categorical(df)
}
\arguments{
\item{df}{(required, data frame) with columns:
\itemize{
\item "x": (character, factor, or numeric) categorical or numeric predictor.
\item "y" (character or factor) categorical response.
}}
}
\value{
numeric: Cramer's V
}
\description{
Computes the Cramer's V between a categorical response (of class "character" or "factor") and the prediction of a Random Forest model with a categorical or numeric predictor and weighted cases.
}
\examples{
#load example data
data(vi)

#reduce size to speed-up example
vi <- vi[1:1000, ]

#categorical response and predictor
#to data frame without NAs
df <- data.frame(
  y = vi[["vi_factor"]],
  x = vi[["soil_type"]]
) |>
  na.omit()

#Cramer's V of a Random Forest model
f_v_rf_categorical(df = df)

#categorical response and numeric predictor
df <- data.frame(
  y = vi[["vi_factor"]],
  x = vi[["swi_mean"]]
) |>
  na.omit()

f_v_rf_categorical(df = df)
}
\seealso{
Other preference_order_functions: 
\code{\link{f_auc}},
\code{\link{f_r2}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()}
}
\concept{preference_order_functions}
