% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order.R
\name{preference_order}
\alias{preference_order}
\title{Quantitative Variable Prioritization for Multicollinearity Filtering}
\usage{
preference_order(
  df = NULL,
  response = NULL,
  predictors = NULL,
  f = "auto",
  warn_limit = NULL,
  quiet = FALSE
)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{response}{(optional; character string or vector) Name/s of response variable/s in \code{df}. Used in target encoding when it names a numeric variable and there are categorical predictors, and to compute preference order. Default: NULL.}

\item{predictors}{(optional; character vector) Names of the predictors to select from \code{df}. If omitted, all numeric columns in \code{df} are used instead. If argument \code{response} is not provided, non-numeric variables are ignored. Default: NULL}

\item{f}{(optional: function) Function to compute preference order. If "auto" (default) or NULL, the output of \code{\link[=f_auto]{f_auto()}} for the given data is used:
\itemize{
\item \code{\link[=f_auc_rf]{f_auc_rf()}}: if \code{response} is binomial.
\item \code{\link[=f_r2_pearson]{f_r2_pearson()}}: if \code{response} and \code{predictors} are numeric.
\item \code{\link[=f_v]{f_v()}}: if \code{response} and \code{predictors} are categorical.
\item \code{\link[=f_v_rf_categorical]{f_v_rf_categorical()}}: if \code{response} is categorical and \code{predictors} are numeric or mixed .
\item \code{\link[=f_r2_rf]{f_r2_rf()}}: in all other cases.
}
Default: NULL}

\item{warn_limit}{(optional, numeric) Preference value (R-squared, AUC, or Cramer's V) over which a warning flagging suspicious predictors is issued. Disabled if NULL. Default: NULL}

\item{quiet}{(optional; logical) If FALSE, messages generated during the execution of the function are printed to the console Default: FALSE}
}
\value{
data frame: columns are "response", "predictor", "f" (function name), and "preference".
}
\description{
Ranks a set of predictors by the strength of their association with a response. Aims to minimize the loss of important predictors during multicollinearity filtering.

The strength of association between the response and each predictor is computed by the function \code{f}. The \code{f} functions available are:
\itemize{
\item \strong{Numeric response vs numeric predictor}:
\itemize{
\item \code{\link[=f_r2_pearson]{f_r2_pearson()}}: Pearson's R-squared.
\item \code{\link[=f_r2_spearman]{f_r2_spearman()}}: Spearman's R-squared.
\item \code{\link[=f_r2_glm_gaussian]{f_r2_glm_gaussian()}}: Pearson's R-squared of response versus the predictions of a Gaussian GLM.
\item \code{\link[=f_r2_glm_gaussian_poly2]{f_r2_glm_gaussian_poly2()}}: Gaussian GLM with second degree polynomial.
\item \code{\link[=f_r2_gam_gaussian]{f_r2_gam_gaussian()}}: GAM model fitted with \code{\link[mgcv:gam]{mgcv::gam()}}.
\item \code{\link[=f_r2_rpart]{f_r2_rpart()}}: Recursive Partition Tree fitted with \code{\link[rpart:rpart]{rpart::rpart()}}.
\item \code{\link[=f_r2_rf]{f_r2_rf()}}: Random Forest model fitted with \code{\link[ranger:ranger]{ranger::ranger()}}.
}
\item \strong{Integer counts response vs. numeric predictor}:
\itemize{
\item \code{\link[=f_r2_glm_poisson]{f_r2_glm_poisson()}}: Pearson's R-squared of a Poisson GLM.
\item \code{\link[=f_r2_glm_poisson_poly2]{f_r2_glm_poisson_poly2()}}: Poisson GLM with second degree polynomial.
\item \code{\link[=f_r2_gam_poisson]{f_r2_gam_poisson()}}: Poisson GAM.
}
\item \strong{Binomial response (1 and 0) vs. numeric predictor}:
\itemize{
\item \code{\link[=f_auc_glm_binomial]{f_auc_glm_binomial()}}: AUC of quasibinomial GLM with weighted cases.
\item \code{\link[=f_auc_glm_binomial_poly2]{f_auc_glm_binomial_poly2()}}: As above with second degree polynomial.
\item \code{\link[=f_auc_gam_binomial]{f_auc_gam_binomial()}}: Quasibinomial GAM with weighted cases.
\item \code{\link[=f_auc_rpart]{f_auc_rpart()}}: Recursive Partition Tree with weighted cases.
\item \code{\link[=f_auc_rf]{f_auc_rf()}}: Random Forest model with weighted cases.
}
\item \strong{Categorical response (character of factor) vs. categorical predictor}:
\itemize{
\item \code{\link[=f_v]{f_v()}}: Cramer's V between two categorical variables.
}
\item \strong{Categorical response vs. categorical or numerical predictor}:
\itemize{
\item \code{\link[=f_v_rf_categorical]{f_v_rf_categorical()}}: Cramer's V of a Random Forest model.
}
}

The name of the used function is stored in the attribute "f_name" of the output data frame. It can be retrieved via \code{attributes(df)$f_name}

Additionally, any custom function accepting a data frame with the columns "x" (predictor) and "y" (response) and returning a numeric indicator of association where higher numbers indicate higher association will work.

This function returns a data frame with the column "predictor", with predictor names ordered by the column "preference", with the result of \code{f}. This data frame, or the column "predictor" alone, can be used as inputs for the argument \code{preference_order} in \code{\link[=collinear]{collinear()}}, \code{\link[=cor_select]{cor_select()}}, and \code{\link[=vif_select]{vif_select()}}.

Accepts a parallelization setup via \code{\link[future:plan]{future::plan()}} and a progress bar via \code{\link[progressr:handlers]{progressr::handlers()}} (see examples).

Accepts a character vector of response variables as input for the argument \code{response}. When more than one response is provided, the output is a named list of preference data frames.
}
\examples{
#subsets to limit example run time
df <- vi[1:1000, ]
predictors <- vi_predictors[1:10]
predictors_numeric <- vi_predictors_numeric[1:10]

#parallelization setup
future::plan(
  future::multisession,
  workers = 2 #set to parallelly::availableCores() - 1
)

#progress bar
# progressr::handlers(global = TRUE)

#numeric response and predictors
#------------------------------------------------
#selects f automatically depending on data features
#applies f_r2_pearson() to compute correlation between response and predictors
df_preference <- preference_order(
  df = df,
  response = "vi_numeric",
  predictors = predictors_numeric,
  f = NULL
  )

#returns data frame ordered by preference
df_preference


#several responses
#------------------------------------------------
responses <- c(
  "vi_categorical",
  "vi_counts"
)

preference_list <- preference_order(
  df = df,
  response = responses,
  predictors = predictors
)

#returns a named list
names(preference_list)
preference_list[[1]]
preference_list[[2]]

#can be used in collinear()
# x <- collinear(
#   df = df,
#   response = responses,
#   predictors = predictors,
#   preference_order = preference_list
# )

#f function selected by user
#for binomial response and numeric predictors
# preference_order(
#   df = vi,
#   response = "vi_binomial",
#   predictors = predictors_numeric,
#   f = f_auc_glm_binomial
# )


#disable parallelization
future::plan(future::sequential)
}
\author{
Blas M. Benito, PhD
}
\concept{preference_order}
