% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_encoding_methods.R
\name{target_encoding_mean}
\alias{target_encoding_mean}
\alias{target_encoding_rank}
\alias{target_encoding_loo}
\title{Target Encoding Methods}
\usage{
target_encoding_mean(
  df = NULL,
  response = NULL,
  predictor = NULL,
  encoded_name = NULL,
  smoothing = 0
)

target_encoding_rank(
  df = NULL,
  response = NULL,
  predictor = NULL,
  encoded_name = NULL,
  smoothing = 0
)

target_encoding_loo(
  df = NULL,
  response = NULL,
  predictor = NULL,
  encoded_name = NULL,
  smoothing = 0
)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{response}{(optional, character string) Name of a numeric response variable in \code{df}. Default: NULL.}

\item{predictor}{(required; string) Name of the categorical predictor to encode. Default: NULL}

\item{encoded_name}{(required, string) Name of the encoded predictor. Default: NULL}

\item{smoothing}{(optional; integer) Groups smaller than this number have their means pulled towards the mean of the response across all cases. Ignored by \code{target_encoding_rank()} and \code{target_encoding_loo()}. Default: 0}
}
\value{
data frame
}
\description{
Target Encoding Methods
}
\examples{

data(vi)

#subset to limit example run time
vi <- vi[1:1000, ]

#mean encoding
#-------------

#without noise
df <- target_encoding_mean(
  df = vi,
  response = "vi_numeric",
  predictor = "soil_type",
  encoded_name = "soil_type_encoded"
)

plot(
  x = df$soil_type_encoded,
  y = df$vi_numeric,
  xlab = "encoded variable",
  ylab = "response"
)

#group rank
#----------

df <- target_encoding_rank(
  df = vi,
  response = "vi_numeric",
  predictor = "soil_type",
  encoded_name = "soil_type_encoded"
)

plot(
  x = df$soil_type_encoded,
  y = df$vi_numeric,
  xlab = "encoded variable",
  ylab = "response"
)


#leave-one-out
#-------------

#without noise
df <- target_encoding_loo(
  df = vi,
  response = "vi_numeric",
  predictor = "soil_type",
  encoded_name = "soil_type_encoded"
)

plot(
  x = df$soil_type_encoded,
  y = df$vi_numeric,
  xlab = "encoded variable",
  ylab = "response"
)
}
\seealso{
Other target_encoding: 
\code{\link{target_encoding_lab}()}

Other target_encoding: 
\code{\link{target_encoding_lab}()}
}
\concept{target_encoding}
