% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/claudia.R
\name{finemap.abf}
\alias{finemap.abf}
\title{Bayesian finemapping analysis}
\usage{
finemap.abf(dataset, p1 = 1e-04)
}
\arguments{
\item{dataset}{a list with specifically named elements defining the dataset
to be analysed. See \code{\link{check_dataset}} for details.}

\item{p1}{prior probability a SNP is associated with the trait 1, default 1e-4}
}
\value{
a \code{data.frame}:
\itemize{
\item an annotated version of the input data containing log Approximate Bayes Factors and intermediate calculations, and the posterior probability of the SNP being causal
}
}
\description{
Bayesian finemapping analysis
}
\details{
This function calculates posterior probabilities of different
causal variant for a single trait.

If regression coefficients and variances are available, it
calculates Bayes factors for association at each SNP.  If only p
values are available, it uses an approximation that depends on the
SNP's MAF and ignores any uncertainty in imputation.  Regression
coefficients should be used if available.
}
\author{
Chris Wallace
}
