% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_visualization.R
\name{plotHist}
\alias{plotHist}
\title{Color histogram of binned image}
\usage{
plotHist(histogram, pausing = TRUE, hsv = FALSE)
}
\arguments{
\item{histogram}{A single dataframe or a list of dataframes as returned by
\code{\link{getImageHist}}, \code{\link{getHistList}}, or
\code{\link{extractClusters}}. First three columns must be color
coordinates and fourth column must be cluster size.}

\item{pausing}{Logical. Pause and wait for keystroke before plotting the next
histogram?}

\item{hsv}{Logical. Should provided color coordinates be interpreted as HSV?
If \code{FALSE}, RGB is assumed.}
}
\description{
Plots a color histogram from a dataframe as returned by
\code{\link{getImageHist}}, \code{\link{getHistList}}, or
\code{\link{extractClusters}}. Bars are colored according to the color of the
bin.
}
\examples{
color_df <- as.data.frame(matrix(rep(seq(0, 1, length.out=3), 3), nrow=3,
ncol=3))

color_df$Pct <- c(0.2, 0.5, 0.3)

colordistance::plotHist(color_df)
}
