% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_metrics.R
\name{colorDistance}
\alias{colorDistance}
\title{Sum of Euclidean distances between color clusters}
\usage{
colorDistance(T1, T2)
}
\arguments{
\item{T1}{Dataframe (especially a dataframe as returned by
\code{extractClusters()} or \code{getImageHist()}, but first three columns
must be coordinates).}

\item{T2}{Another dataframe like T1.}
}
\value{
Sum of Euclidean distances between each pair of points (rows) in the
  provided dataframes.
}
\description{
Calculates the Euclidean distance between each pair of points in two
dataframes as returned by extractClusters or getImageHist and returns the sum
of the distances.
}
\examples{
cluster.list <- colordistance::getHistList(system.file("extdata",
"Heliconius/Heliconius_B", package="colordistance"), lower=rep(0.8, 3),
upper=rep(1, 3))
colordistance:::colorDistance(cluster.list[[1]], cluster.list[[2]])
}
