% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_repel.R
\name{color_repel}
\alias{color_repel}
\title{Reorder ggplot colors to maximize color differences in space}
\usage{
color_repel(
  g,
  coord = NULL,
  groups = NULL,
  nsamp = 50000,
  sim = NULL,
  severity = 0.5,
  verbose = FALSE,
  downsample = 5000,
  seed = 34,
  col = "colour",
  autoswitch = TRUE,
  layer = 1,
  out_orig = FALSE,
  out_worst = FALSE
)
}
\arguments{
\item{g}{ggplot plot object}

\item{coord}{coordinates, default is inferred}

\item{groups}{groups corresponding to color/fill, default is inferred}

\item{nsamp}{how many random sampling color combinations to test, default 50000}

\item{sim}{passing a colorbind simulation function if needed}

\item{severity}{severity of the color vision defect, between 0 and 1}

\item{verbose}{whether to print messages}

\item{downsample}{downsample when too many datapoints are present, or use chull}

\item{seed}{sampling randomization seed}

\item{col}{colour or fill in ggplot}

\item{autoswitch}{try to switch between colour and fill automatically}

\item{layer}{layer to detect color, defaults to first}

\item{out_orig}{output the original colors as named vector}

\item{out_worst}{output the worst combination instead of best}
}
\value{
vector of reordered colors
}
\description{
Reorder ggplot colors to maximize color differences in space
}
\examples{
a <- ggplot2::ggplot(ggplot2::mpg, ggplot2::aes(displ, hwy)) +
  ggplot2::geom_point(ggplot2::aes(color = as.factor(cyl)))
new_colors <- color_repel(a)
b <- a + ggplot2::scale_color_manual(values = new_colors)
}
