% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onLoad.R
\docType{package}
\name{cols4all-package}
\alias{cols4all-package}
\alias{cols4all}
\title{cols4all overview}
\description{
cols4all stands for: color palettes for all people, including those with color vision deficiency. Popular color palette series, such as ColorBrewer, have been organized by type and have been scored on several properties such as color-blind-friendliness and fairness (i.e. do colors stand out equally?). Own palettes can also be loaded and analysed. Besides the common palette types (categorical, sequential, and diverging) it also includes bivariate color palettes. ggplot2 scales are included.
}
\details{
This page provides a brief overview of all package functions.
}
\section{Main functions}{

\tabular{ll}{
\code{\link{c4a_gui}}\tab Dashboard for analyzing the palettes \cr
\code{\link{c4a}}\tab Get the colors from a palette (\code{\link{c4a_na}} for the associated color for missing values) \cr
\code{\link{c4a_plot}}\tab Plot a color palette \cr
}
}

\section{Palette names and properties}{

\tabular{ll}{
\code{\link{c4a_palettes}}\tab Get available palette names \cr
\code{\link{c4a_series}}\tab Get available series names\cr
\code{\link{c4a_overview}}\tab Get an overview of palettes per series x type\cr
\code{\link{c4a_citation}}\tab Show how to cites palettes (with bibtex code) \cr
\code{\link{c4a_info}}\tab Get information from a palette, such as type and maximum number of colors) \cr
\code{\link{.P}}\tab Environment via which palette names can be browsed with auto-completion (using \code{$}) \cr
}
}

\section{Importing and exporting palettes}{

\tabular{ll}{
\code{\link{c4a_data}}\tab Build color palette data \cr
\code{\link{c4a_load}}\tab Load color palette data \cr
\code{\link{c4a_sysdata_import}}\tab Import system data \cr
\code{\link{c4a_sysdata_export}}\tab Export system data \cr
}
}

\seealso{
\url{https://github.com/mtennekes/cols4all}
}
\author{
Martijn Tennekes \email{mtennekes@gmail.com}
}
\concept{color}
\concept{visualization}
