% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Piepho_test.R
\name{Piepho.test}
\alias{Piepho.test}
\title{Piepho (1994) Test for Interaction}
\usage{
Piepho.test(x, nsim = 10000)
}
\arguments{
\item{x}{numeric matrix, \eqn{b \times a} data matrix where the number of rows and columns are corresponding to the block and treatment levels, respectively.}

\item{nsim}{a numeric value, the number of Monte Carlo samples for computing an exact Monte Carlo p-value. The default value is 10000.}
}
\value{
An object of the class \code{ITtest}, which is a list inducing following components:
\item{pvalue.exact}{The calculated exact Monte Carlo p-value.}
\item{pvalue.appro}{The asymptotic p-value.}
\item{statistic}{The value of the test statistic.}
\item{Nsim}{The number of Monte Carlo samples that are used to estimate p-value.}
\item{data.name}{The name of the input dataset.}
\item{test}{The name of the test.}
}
\description{
This function tests the interaction based on a statistic proposed by Piepho (1994).
This function reports Piepho's test statistic, and the asymptotic and Monte Carlo p-values.
}
\details{
Piepho (1994) proposed three test statistics.The third one is
 based on Grubbs’ (1948) type estimator of variance for each level of block effect.
 This type of estimator is used in this function. Piepho (1994) proposed an asymptotic distribution of test statistic; however, we use a Monte Carlo method to calculate the p-value.
 Note that Piepho’s test is powerful for detecting interactions when the Grubbs’ type estimators of variances are heterogeneous across the levels of one factor.
}
\examples{
data(MVGH)
Piepho.test(MVGH, nsim = 1000)

}
\references{
Piepho, H. P. (1994). On Tests for Interaction in a Nonreplicated Two-Way Layout. Australian
Journal of Statistics 36:363-369.

Shenavari, Z., Kharrati-Kopaei, M. (2018). A Method for Testing Additivity in
Unreplicated Two-Way Layouts Based on Combining Multiple Interaction Tests. International Statistical Review
86(3): 469-487.

Grubbs, F.E. (1948). On Estimating Precision of Measuring Instruments and Product Variability. Journal of the American Statistical Association 43(242): 243-264.
}
