% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Malik_test.R
\name{Malik.test}
\alias{Malik.test}
\title{Malik's (2016) et al. Test for Interaction}
\usage{
Malik.test(x, nsim = 10000, alpha = 0.05, report = TRUE, Elapsed.time = TRUE)
}
\arguments{
\item{x}{numeric matrix, \eqn{a \times b} data matrix where the number of row and column is corresponding to the number of factor levels.}

\item{nsim}{a numeric value, the number of Monte Carlo samples for computing an exact Monte Carlo p-value. The default value is 10000.}

\item{alpha}{a numeric value, the level of the test. The default value is 0.05.}

\item{report}{logical: if \code{TRUE} the result of the test is reported at the \code{alpha} level.}

\item{Elapsed.time}{logical: if \code{TRUE} the progress will be printed in the console.}
}
\value{
An object of the class \code{ITtest}, which is a list inducing following components:
\item{pvalue.exact}{The calculated exact Monte Carlo p-value.}
\item{pvalue.appro}{is not available for \code{Malik.test}.}
\item{statistic}{The value of the test statistic.}
\item{Nsim}{The number of Monte Carlo samples that are used to estimate p-value.}
\item{data.name}{The name of the input dataset.}
\item{test}{The name of the test.}
\item{Level}{The level of test.}
\item{Result}{The result of the test at the alpha level with some descriptions on the type of significant interaction.}
}
\description{
The Malik's (2016) et al. test statistic is calculated and the corresponding exact p-value is calculated by a Monte Carlo simulation.
}
\details{
Malik (2016) et al. proposed to partition
 the residuals into three clusters using a suitable clustering method like “k-means clustering”.
 The hypothesis of no interaction can be interpreted as the effect of the three
 clusters are equal. Therefore, the result of the test may depend on the method of clustering. In this package, clustering is done by \code{kmeans} function in \code{RcppArmadillo}. The \code{speed_mode} parameter on the kmeans clustering was set as \code{static_subset}.
 Note that the Malik's et al. test performs well when there are some outliers in the residuals; i.e. some cells produce large negative or positive residuals due to the significant interaction.
 Further, the distribution of the Malik's et al. test statistic is not known under additivity and the corresponding p-value is calculated by a Monte Carlo simulation.
}
\examples{
\dontrun{
data(IDCP)
Malik.test(IDCP, nsim = 1000, Elapsed.time = FALSE)
}
}
\references{
Malik, W.A., Mohring, J., Piepho, H.P. (2016). A
clustering-based test for non-additivity in an unreplicated two-way layout.
Communications in Statistics-Simulation and Computation 45(2):660-670.

Shenavari, Z., Kharrati-Kopaei, M. (2018). A Method for Testing Additivity in
Unreplicated Two-Way Layouts Based on Combining Multiple Interaction Tests. International Statistical Review
86(3): 469-487.
}
