% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify.R
\name{classify}
\alias{classify}
\title{Classify data.frames using glm(link='binomial') models.}
\usage{
classify(
  unclassified_data,
  Models,
  Metrics,
  Positive_class = 1,
  Negative_class = 0
)
}
\arguments{
\item{unclassified_data}{a data.frame returned by load_unclassified_data().}

\item{Models}{a list of glm() objects returned by roc_reports().}

\item{Metrics}{a list of data.frame objects containing ROC metrics, returned by roc_reports().}

\item{Positive_class}{a numeric or a character that specifies the label of the samples that will be classified as positives}

\item{Negative_class}{a numeric or a character that specifies the label of the samples that will be classified as negatives}
}
\value{
a data.frame containing the predicted class of each sample, for each marker/combination in Models
}
\description{
A function that applies the previously calculated models to an unclassified dataset and classifies the samples.
}
\details{
This function  can classify dataset loaded with load_unclassified_data() that MUST contain all the markers of the classified dataset used to train the models (the one loaded with load_data()).
}
\examples{
demo_data # combiroc built-in demo data (proteomics data from Zingaretti et al. 2012 - PMC3518104)
demo_unclassified_data # combiroc built-in unclassified demo data

combs <- combi(data= demo_data, signalthr=450, combithr=1)  # compute combinations

reports <- roc_reports(data= demo_data, markers_table= combs,
                       selected_combinations= c(1,11,15),
                       single_markers=c('Marker1', 'Marker2'), case_class='A') # train logistic
                                                                               # regression models


# To classify new samples with logistic regression models.

classified_data <- classify(unclassified_data= demo_unclassified_data, Models= reports$Models,
                             Metrics= reports$Metrics, Positive_class=1, Negative_class=0)

classified_data  # show samples classified using Logistic regression models
}
