% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item-summary.R
\name{item-summary-join}
\alias{item-summary-join}
\alias{join_item_summary}
\alias{join_game_summary}
\alias{join_player_summary}
\title{Join item summary}
\usage{
join_item_summary(tbl, item, ..., .prefix = "")

join_game_summary(tbl, ..., .prefix = "")

join_player_summary(tbl, ..., .prefix = "")
}
\arguments{
\item{tbl}{Data frame.}

\item{item}{Character vector of columns to group by.}

\item{...}{Name-value pairs of summary functions (as in \link[dplyr:summarise]{dplyr::summarise}).}

\item{.prefix}{A string to be added to all summary functions' names.}
}
\value{
Result of \code{left_join()} to the input data frame.
}
\description{
Functions for joining summary data to data frame. They perform respective
variant of \link[=item-summary]{summarise item functions} and then \link[dplyr:left_join]{left
join} to the input its result (by \code{item} columns).
}
\details{
\code{join_game_summary()} and \code{join_player_summary()} are wrappers for
\code{join_item_summary()} using \code{item = "game"} and \code{item = "player"}
respectively.
}
\examples{
ncaa2005 \%>\% join_player_summary(player_mean_score = mean(score))

}
\seealso{
\link[=item-summary]{Compute item summary}

Common item \link[=summary_funs]{summary functions} for competition results.
}
