#' Bonobo sociomatrix
#'
#' A win-loss sociomatrix with each row being the number of wins
#' against individual bonobos in each column.
#'
#' Reference: Vervaecke, H., de Vries, H. & van Elsacker, L. 2000.
#' Dominance and its behavioral measures in a captive group of
#' bonobos (Pan paniscus). International Journal of Primatology,
#' 21, 47-68.
#'
#' @format A data frame with 6 rows and 6 variables:
#' \describe{
#'   \item{Dz}{The number of losses by bonobo Dz against all other bonobos}
#'   \item{He}{The number of losses by bonobo He against all other bonobos}
#'   \item{De}{The number of losses by bonobo De against all other bonobos}
#'   \item{Ho}{The number of losses by bonobo Ho against all other bonobos}
#'   \item{Lu}{The number of losses by bonobo Lu against all other bonobos}
#'   \item{Ki}{The number of losses by bonobo Ki against all other bonobos}
#' }
"bonobos"
