% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlm.wfit.R
\name{zmodel.matrix}
\alias{zmodel.matrix}
\title{Generate a Model Matrix (Design Matrix) Using Complex Variables}
\usage{
zmodel.matrix(trms, data, contrasts.arg = NULL)
}
\arguments{
\item{trms}{A "terms" object as generated by \code{\link[stats:terms]{stats::terms()}}.}

\item{data}{A data frame containing the data referenced by the symbolic formula / model in \code{trms}.}

\item{contrasts.arg}{a list, default is NULL. Not currently supported. See \code{\link[stats:model.matrix]{stats::model.matrix()}} for details.}
}
\value{
A model matrix, AKA a design matrix for a regression, containing the relevant information from \code{data}.
}
\description{
A function that somewhat replicates model.matrix(), but accepts complex valued data. It will probably be slower and less efficient, but mostly functional.
It cannot handle algebraic expressions in formula.
}
\examples{
set.seed(4242)
slop <- complex(real = 4.23, imaginary = 2.323)
interc <- complex(real = 1.4, imaginary = 1.804)
tframe <- expand.grid(-3:3,-3:3)
Xt <- complex(real = tframe[[1]], imaginary = tframe[[2]])
tframe <- data.frame(Xt=Xt, Yt= Xt * slop + interc + complex(real=rnorm(length(Xt)),
 imaginary=rnorm(length(Xt))))
testterms <- terms(Yt ~ Xt)
zmodel.matrix(testterms, tframe)
}
\seealso{
\link[stats:model.matrix]{stats::model.matrix}, \link{lm}
}
