% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bootStat-methods}
\alias{bootStat-methods}
\alias{bootStatCases}
\alias{bootStatFast}
\alias{bootStatFastControl}
\alias{bootStatResiduals}
\title{Bootstrap statistics functions}
\usage{
bootStatResiduals(residData, inds, coefind, intercept = TRUE, maxTries = 4L)

bootStatCases(origData, inds, coefind, formula, maxTries = 4L)

bootStatFastControl(model)

bootStatFast(origData, inds, control, coefind)
}
\arguments{
\item{origData}{the original data set.}

\item{residData}{the original data set with the columns fit, resid and the predictor variables instead of
the response variable.}

\item{model}{The lmrob model}

\item{inds}{the resampled indices.}

\item{coefind}{the index of the coefficient to extract.}

\item{control}{the control object as returned by \code{bootStatFastControl}.}

\item{formula}{the formula to fit the model}

\item{intercept}{if the model includes an intercept term.}

\item{maxTries}{the maximum number of tries to increase the maxit control arguments for the S estimator.}
}
\description{
Functions to calculate the coefficient(s) of the robust linear regression model
from a bootstrapped sample
}
\details{
Different approaches for bootstrapping have been implemented. The default "fast and robust bootstrap"
(FRB) proposed by M. Salibian-Barrera, et al. (2002), implemented with \code{bootStatFast} is the
fastest and most resistant to outliers, while the other two \code{bootStatResiduals} and \code{bootStatCases}
are standard bootstrap methods, where the residuals resp. the cases are resampled and the model is
fit to this data.
}
\references{
M. Salibian-Barrera, S. Aelst, and G. Willems. Fast and robust bootstrap. Statistical Methods and Applications, 17(1):41-71, 2008.
}
\seealso{
\code{\link{bootcoefs}}
}

