% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.comparison.R
\name{calculate.layer.contribution}
\alias{calculate.layer.contribution}
\title{Calculate layer contribution}
\usage{
calculate.layer.contribution(conStruct.results, data.block, layer.order = NULL)
}
\arguments{
\item{conStruct.results}{The list output by a 
\code{conStruct} run for a given MCMC chain.}

\item{data.block}{A \code{data.block} list saved during a 
\code{conStruct} run.}

\item{layer.order}{An optional \code{vector} giving the
order in which the layers of \code{conStruct.results} are 
    read.}
}
\value{
This function returns a \code{vector} giving the 
			relative contributions of the layers 
			in the analysis.
}
\description{
\code{calculate.layer.contribution}
}
\details{
This function takes the results of a \code{conStruct} 
analysis and calculates the relative contributions of 
each layer to total covariance.

This function calculates the contribution of each layer to
		total covariance by multiplying the within-layer covariance 
		in a given layer by the admixture proportions samples draw 
		from that layer. The relative contribution of that layer 
		is this absolute contribution divided by the sum of those of 
		all other layers. 
			A layer can have a large contribution if many samples draw 
		large amounts of admixture from it, or if it has a very large 
		within-layer covariance parameter (phi), or some combination 
		of the two. Layer contribution can be useful for evaluating 
		an appropriate level of model complexity for the data (e.g., 
		choosing a value of \code{K} or comparing the spatial and 
		nonspatial models).
}
