% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_skew_and_kurtosis.R
\name{ci_skewness}
\alias{ci_skewness}
\title{CI for the Skewness}
\usage{
ci_skewness(
  x,
  probs = c(0.025, 0.975),
  type = "bootstrap",
  boot_type = c("bca", "perc", "norm", "basic"),
  R = 9999L,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{probs}{Lower and upper probabilities, by default \code{c(0.025, 0.975)}.}

\item{type}{Type of CI. Currently not used as the only type is \code{"bootstrap"}.}

\item{boot_type}{Type of bootstrap CI. Only used for \code{type = "bootstrap"}.}

\item{R}{The number of bootstrap resamples. Only used for \code{type = "bootstrap"}.}

\item{seed}{An integer random seed. Only used for \code{type = "bootstrap"}.}

\item{...}{Further arguments passed to \code{\link[boot:boot]{boot::boot()}}.}
}
\value{
An object of class "cint", see \code{\link[=ci_mean]{ci_mean()}} for details.
}
\description{
This function calculates bootstrap CIs for the population skewness.
By default, bootstrap type "bca" is used.
}
\examples{
x <- 1:20
ci_skewness(x, R = 999)  # Use larger R
}
\seealso{
\code{\link[=skewness]{skewness()}}, \code{\link[=ci_kurtosis]{ci_kurtosis()}}
}
