% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_groups}
\alias{get_groups}
\title{Get group information from the Posit Connect server}
\usage{
get_groups(src, page_size = 20, prefix = NULL, limit = 25)
}
\arguments{
\item{src}{The source object}

\item{page_size}{the number of records to return per page (max 500)}

\item{prefix}{Filters groups by prefix (group name).
The filter is case insensitive.}

\item{limit}{The max number of groups to return}
}
\value{
A tibble with the following columns:
\itemize{
\item{\strong{guid}}{The unique identifier of the group}
\item{\strong{name}}{The group name}
\item{\strong{owner_guid}}{The group owner's unique identifier.
When using LDAP, or Proxied authentication with group provisioning
enabled this property will always be null.}
}
}
\description{
Get group information from the Posit Connect server
}
\details{
Please see https://docs.posit.co/connect/api/#getGroups for more information
}
\examples{
\dontrun{
library(connectapi)
client <- connect()

# get all groups
get_groups(client, limit = Inf)
}

}
