% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrations.R
\name{create_integration}
\alias{create_integration}
\title{Create an OAuth integration}
\usage{
create_integration(client, name, description = NULL, template, config)
}
\arguments{
\item{client}{A \code{Connect} R6 client object.}

\item{name}{A descriptive name to identify the integration.}

\item{description}{Optional, default \code{NULL.} A brief description of the integration.}

\item{template}{The template to use to configure this integration (e.g.,
"custom", "github", "google", "connect").}

\item{config}{A list containing the configuration for the integration. The
required fields vary depending on the template selected.}
}
\value{
A \code{connect_integration} object representing the newly created
integration. See \code{\link[=get_integration]{get_integration()}} for details on the returned object.
}
\description{
Creates a new OAuth integration on the Posit Connect server. OAuth integrations
allow content to access external resources using OAuth credentials.

You must have administrator privileges to perform this action.

See the Posit Connect documentation on
\href{https://docs.posit.co/connect/admin/integrations/oauth-integrations/}{OAuth integrations} for
more information.
}
\examples{
\dontrun{
client <- connect()

# Create a GitHub OAuth integration
github_integration <- create_integration(
  client,
  name = "GitHub Integration",
  description = "Integration with GitHub for OAuth access",
  template = "github",
  config = list(
    client_id = "your-client-id",
    client_secret = "your-client-secret"
  )
)

# Create a custom OAuth integration
custom_integration <- create_integration(
  client,
  name = "Custom API Integration",
  description = "Integration with our custom API",
  template = "custom",
  config = list(
    auth_mode = "Confidential",
    auth_type = "Viewer",
    authorization_uri = "https://api.example.com/oauth/authorize",
    client_id = "your-client-id",
    client_secret = "your-client-secret",
    token_uri = "https://api.example.com/oauth/token"
  )
)
}

}
\seealso{
\code{\link[=get_integrations]{get_integrations()}}, \code{\link[=get_integration]{get_integration()}}, \code{\link[=update_integration]{update_integration()}},
\code{\link[=delete_integration]{delete_integration()}}

Other oauth integration functions: 
\code{\link{delete_integration}()},
\code{\link{get_associations}()},
\code{\link{get_integration}()},
\code{\link{get_integrations}()},
\code{\link{set_integrations}()},
\code{\link{update_integration}()}
}
\concept{oauth integration functions}
