% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conclass.R
\name{Conos}
\alias{Conos}
\title{Conos R6 class}
\description{
The class encompasses sample collections, providing methods for calculating and visualizing joint graph and communities.
}
\examples{

## ------------------------------------------------
## Method `Conos$new`
## ------------------------------------------------

con <- Conos$new(small_panel.preprocessed, n.cores=1)


## ------------------------------------------------
## Method `Conos$buildGraph`
## ------------------------------------------------

con <- Conos$new(small_panel.preprocessed, n.cores=1)
con$buildGraph(k=10, k.self=5, space='PCA', ncomps=10, n.odgenes=20, matching.method='mNN', 
    metric='angular', score.component.variance=TRUE, verbose=TRUE)



## ------------------------------------------------
## Method `Conos$findCommunities`
## ------------------------------------------------

con <- Conos$new(small_panel.preprocessed, n.cores=1)
con$buildGraph(k=10, k.self=5, space='PCA', ncomps=10, n.odgenes=20, matching.method='mNN', 
    metric='angular', score.component.variance=TRUE, verbose=TRUE)
con$findCommunities(method = igraph::walktrap.community, steps=5)


## ------------------------------------------------
## Method `Conos$getDatasetPerCell`
## ------------------------------------------------

con <- Conos$new(small_panel.preprocessed, n.cores=1)
con$getDatasetPerCell()


## ------------------------------------------------
## Method `Conos$getJointCountMatrix`
## ------------------------------------------------

con <- Conos$new(small_panel.preprocessed, n.cores=1)
con$getJointCountMatrix()

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{samples}}{list of samples (Pagoda2 or Seurat objects)}

\item{\code{pairs}}{pairwise alignment results}

\item{\code{graph}}{alignment graph}

\item{\code{clusters}}{list of clustering results named by clustering type}

\item{\code{expression.adj}}{adjusted expression values}

\item{\code{embeddings}}{list of joint embeddings}

\item{\code{embedding}}{joint embedding}

\item{\code{n.cores}}{number of cores}

\item{\code{misc}}{list with unstructured additional info}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Conos$new()}}
\item \href{#method-addSamples}{\code{Conos$addSamples()}}
\item \href{#method-buildGraph}{\code{Conos$buildGraph()}}
\item \href{#method-getDifferentialGenes}{\code{Conos$getDifferentialGenes()}}
\item \href{#method-findCommunities}{\code{Conos$findCommunities()}}
\item \href{#method-plotPanel}{\code{Conos$plotPanel()}}
\item \href{#method-embedGraph}{\code{Conos$embedGraph()}}
\item \href{#method-plotClusterStability}{\code{Conos$plotClusterStability()}}
\item \href{#method-plotGraph}{\code{Conos$plotGraph()}}
\item \href{#method-correctGenes}{\code{Conos$correctGenes()}}
\item \href{#method-propagateLabels}{\code{Conos$propagateLabels()}}
\item \href{#method-getClusterCountMatrices}{\code{Conos$getClusterCountMatrices()}}
\item \href{#method-getDatasetPerCell}{\code{Conos$getDatasetPerCell()}}
\item \href{#method-getJointCountMatrix}{\code{Conos$getJointCountMatrix()}}
\item \href{#method-clone}{\code{Conos$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
initialize Conos class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$new(
  x,
  ...,
  n.cores = parallel::detectCores(logical = FALSE),
  verbose = TRUE,
  override.conos.plot.theme = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{a named list of pagoda2 or Seurat objects (one per sample)}

\item{\code{...}}{additional parameters upon initializing Conos}

\item{\code{n.cores}}{numeric Number of cores to use (default=parallel::detectCores(logical=FALSE))}

\item{\code{verbose}}{boolean Whether to provide verbose output (default=TRUE)}

\item{\code{override.conos.plot.theme}}{boolean Whether to reset plot settings to the ggplot2 default (default=FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new 'Conos' object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{con <- Conos$new(small_panel.preprocessed, n.cores=1)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addSamples"></a>}}
\if{latex}{\out{\hypertarget{method-addSamples}{}}}
\subsection{Method \code{addSamples()}}{
Initialize or add a set of samples to the conos panel. Note: this will simply add samples, but will not update graph, clustering, etc.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$addSamples(x, replace = FALSE, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{a named list of pagoda2 or Seurat objects (one per sample)}

\item{\code{replace}}{boolean Whether the existing samples should be purged before adding new ones (default=FALSE)}

\item{\code{verbose}}{boolean Whether to provide verbose output (default=FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible view of the full sample list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-buildGraph"></a>}}
\if{latex}{\out{\hypertarget{method-buildGraph}{}}}
\subsection{Method \code{buildGraph()}}{
Build the joint graph that encompasses all the samples, establishing weighted inter-sample cell-to-cell links
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$buildGraph(
  k = 15,
  k.self = 10,
  k.self.weight = 0.1,
  alignment.strength = NULL,
  space = "PCA",
  matching.method = "mNN",
  metric = "angular",
  k1 = k,
  data.type = "counts",
  l2.sigma = 1e+05,
  var.scale = TRUE,
  ncomps = 40,
  n.odgenes = 2000,
  matching.mask = NULL,
  exclude.samples = NULL,
  common.centering = TRUE,
  verbose = TRUE,
  base.groups = NULL,
  append.global.axes = TRUE,
  append.decoys = TRUE,
  decoy.threshold = 1,
  n.decoys = k * 2,
  score.component.variance = FALSE,
  snn = FALSE,
  snn.quantile = 0.9,
  min.snn.jaccard = 0,
  min.snn.weight = 0,
  snn.k.self = k.self,
  balance.edge.weights = FALSE,
  balancing.factor.per.cell = NULL,
  same.factor.downweight = 1,
  k.same.factor = k,
  balancing.factor.per.sample = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{k}}{integer integer Size of the inter-sample neighborhood (default=15)}

\item{\code{k.self}}{integer Size of the with-sample neighborhoods (default=10).}

\item{\code{k.self.weight}}{numeric Weight multiplier on the intra-sample edges relative to inter-sample edges (default=0.1)}

\item{\code{alignment.strength}}{numeric Alignment strength (default=NULL will result in alignment.strength=0)}

\item{\code{space}}{character Reduced expression space used to establish putative alignments between pairs of samples (default='PCA'). Currently supported spaces are:
--- "CPCA" Common principal component analysis
--- "JNMF" Joint NMF
--- "genes" Gene expression space (log2 transformed)
--- "PCA" Principal component analysis
--- "CCA" Canonical correlation analysis
--- "PMA" (Penalized Multivariate Analysis <https://cran.r-project.org/web/packages/PMA/index.html>)}

\item{\code{matching.method}}{character Matching method (default='mNN'). Currently supported methods are "NN" (nearest neighbors) or "mNN" (mututal nearest neighbors).}

\item{\code{metric}}{character Distance metric to measure similarity (default='angular'). Currenlty supported metrics are "angular" and "L2".}

\item{\code{k1}}{numeric Neighborhood radius for identifying mutually-matching neighbors (default=k). Note that k1 must be greater than or equal to k, i.e. k1>=k. Increasing k1 beyond k will lead to more aggressive alignment of distinct subpopulations (i.e. increased alignment strengths).}

\item{\code{data.type}}{character Type of data type in the input pagoda2 objects within r.n (default='counts').}

\item{\code{l2.sigma}}{numeric L2 distances get transformed as exp(-d/sigma) using this value (default=1e5)}

\item{\code{var.scale}}{boolean Whether to use common variance scaling (default=TRUE). If TRUE, use geometric means for variance, as we're trying to focus on the common variance components. See scaledMatricesP2() code.}

\item{\code{ncomps}}{integer Number of components (default=40)}

\item{\code{n.odgenes}}{integer Number of overdispersed genes to be used in each pairwise alignment (default=2000)}

\item{\code{matching.mask}}{an optional matrix explicitly specifying which pairs of samples should be compared (a symmetrical matrix of logical values with row and column names corresponding to sample names). (default=NULL). By default, comparisons between all paris are allowed. The argument can be used to exclude comparisons across certain pairs of samples (e.g. techincal replicates, which are expected to show very high similarity).}

\item{\code{exclude.samples}}{optional list of sample names that should be excluded from the alignment and the resulting graph (default=NULL)}

\item{\code{common.centering}}{boolean When calculating reduced expression space for a given sample pair, whether the expression of genes should be centered using the mean from both samples (TRUE) or using the mean within each sample (FALSE) (default=TRUE)}

\item{\code{verbose}}{boolean Whether to provide verbose output (default=TRUE)}

\item{\code{base.groups}}{an optional factor on cells specifying previously-obtained cell grouping to be used for adjusting the sample alignment (default: NULL). Specifically, cell clusters specfiieid by the base.groups can be used to i) calculate global expression axes which are appended to the overall set of eigenvectors, ii) adding decoy cells.}

\item{\code{append.global.axes}}{boolean Whether to project samples on global expression axes, as defined by pre-defined (typically crude) set of cell subpopulations as specified by the base.gruops parameter (default=TRUE, but works only if base.groups is specified)}

\item{\code{append.decoys}}{boolean Whether to use pre-defined cell groups (specified by base.groups) to append decoy cells to the samples which are otherwise lacking any of the pre-specified cell groups (default=TRUE, but works only if base.groups is specified). The decoy cells can reduce the number of erroneous matches in highly heterogeneous sample collections, where some of the samples lack entire cell subpopulations which are found in other samples. The approach only works if the base.groups (typically a crude clustering of top-level cell types) can be established with a reasonable confidence.}

\item{\code{decoy.threshold}}{integer Minimal number of cells of a given cell type that should exist in a given sample (according to base.groups) to avoid addition of decoy cells to that sample for the purposes of alignment (default=1)}

\item{\code{n.decoys}}{integer Number of decoy cells that should be added to a sample that had less than decoy.threshold cells of a given cell type (default=k*2)}

\item{\code{score.component.variance}}{boolean Whether to score the amount of total variance explained by different components (default=FALSE as it takes extra time to calculate)}

\item{\code{snn}}{boolean Whether to transform the joint graph by computing a shared nearest neighborhood graph (analogous to Seurat 3), further weighting the edges between two matched cells based on the similarity (measured by Jaccard coefficient) of all of their predicted neighbors (across all of the samples) (default: FALSE)}

\item{\code{snn.quantile}}{numeric Specifies how the shared neighborhood graph transformation will determine final edge weights. If snn.quantile=NULL, the edge weight will be simply equal to the Jaccard coefficient of the neighborhoods. If snn.quantile is a vector of two numeric values (p1, p2), they will be treated as quantile probabilities, and quantile values (q1,q2) on the set of all Jaccard coefficients (for all edges) will be determiend. The edge weights will then be reset, so that edges with Jaccard coefficients below or equal to q1 will be set to 0, and those with coefficients >=q2 will be set to 1. The rest of the weights will be mapped uniformly from [q1,q2]->[0,1] range. If a single numeric value is supplied, it will be treated as a symmetric quantile probability (i.e. snn.quantile=0.8 is equivalent to specifying snn.quantile=c(1-0.8,0.8)). (default: 0.9)}

\item{\code{min.snn.jaccard}}{numeric Minimum Jaccard coefficient required for a shared neighborhood graph edge (default: 0). The edges with Jaccard coefficients below this threshold will be removed (i.e. weight set to 0)}

\item{\code{min.snn.weight}}{numeric Shared nearest neighbor procedure will adjust the weights of the edges, and even eliminate some of the edges (by setting their weight to zero). The min.snn.weight parameter allows to set a minimal adjusted edge weight, so that the edge weight is never reduced beyond this level (and hence never deleted) (default: 0 - no adjustments)}

\item{\code{snn.k.self}}{integer Size of the within-sample neighorhood to be used in shared nearest neighbor calculations (default=k.self)}

\item{\code{balance.edge.weights}}{boolean Whether to balance edge weights to control for a cell- or sample- specific factor (default=FALSE)}

\item{\code{balancing.factor.per.cell}}{A per-cell factor (discrete factor, named with cell names) specifying a design difference should be controlled for by adjusting edge weights in the joint graph (default=NULL)}

\item{\code{same.factor.downweight}}{numeric Optional weighting factor for edges connecting cells with the same cell factor level per cell balancing (default=1.0)}

\item{\code{k.same.factor}}{integer An neighborhood size that should be used when aligning samples of the same balancing.factor.per.sample level. Setting a value smaller than k will lead to reduction of alingment strenth within the sample batches (default=k)}

\item{\code{balancing.factor.per.sample}}{A covariate factor per sample that should be controlled for by adjusting edge weights in the joint graph (default=NULL)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
joint graph to be used for downstream analysis
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{con <- Conos$new(small_panel.preprocessed, n.cores=1)
con$buildGraph(k=10, k.self=5, space='PCA', ncomps=10, n.odgenes=20, matching.method='mNN', 
    metric='angular', score.component.variance=TRUE, verbose=TRUE)


}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDifferentialGenes"></a>}}
\if{latex}{\out{\hypertarget{method-getDifferentialGenes}{}}}
\subsection{Method \code{getDifferentialGenes()}}{
Calculate genes differentially expressed between cell clusters. Estimates base mean, z-score, p-values, specificity, precision, expressionFraction, AUC (if append.auc=TRUE)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$getDifferentialGenes(
  clustering = NULL,
  groups = NULL,
  z.threshold = 3,
  upregulated.only = FALSE,
  verbose = TRUE,
  append.specificity.metrics = TRUE,
  append.auc = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{clustering}}{character Name of the clustering to use (see names(con$clusters)) for the value of the groups factor (default: NULL - if groups are not specified, the first clustering will be used)}

\item{\code{groups}}{a cell factor (a factor named with cell names) specifying clusters of cells to be compared (one against all). To compare two cell clusters against each other, simply pass a factor containing only two levels (default: NULL, see clustering)}

\item{\code{z.threshold}}{numeric Minimum absolute value of a Z score for which the genes should be reported (default=3.0).}

\item{\code{upregulated.only}}{boolean If TRUE, will report only genes significantly upregulated in each cluster; otherwise both up- and down-regulated genes will be reported (default=FALSE)}

\item{\code{verbose}}{boolean Whether to provide verbose output (default=TRUE)}

\item{\code{append.specificity.metrics}}{boolean Whether to append specificity metrics (default=TRUE)}

\item{\code{append.auc}}{boolean Whether to append AUC scores (default=TRUE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list of DE results; each is a data frame with rows corresponding to the differentially expressed genes, and columns listing log2 fold change (M), signed Z scores (both raw and adjusted for mulitple hypothesis using BH correction), optional specificty/sensitivity and AUC metrics.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-findCommunities"></a>}}
\if{latex}{\out{\hypertarget{method-findCommunities}{}}}
\subsection{Method \code{findCommunities()}}{
Find cell clusters (as communities on the joint graph)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$findCommunities(
  method = leiden.community,
  min.group.size = 0,
  name = NULL,
  test.stability = FALSE,
  stability.subsampling.fraction = 0.95,
  stability.subsamples = 100,
  verbose = TRUE,
  cls = NULL,
  sr = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{community detection method (igraph syntax) (default=leiden.community)}

\item{\code{min.group.size}}{numeric Minimal allowed community size (default=0)}

\item{\code{name}}{character Optional name of the clustering result (will default to the algorithm name) (default=NULL will try to obtain the name from the community detection method, or will use 'community' as a default)}

\item{\code{test.stability}}{boolean Whether to test stability of community detection (default=FALSE)}

\item{\code{stability.subsampling.fraction}}{numeric Fraction of clusters to subset (default=0.95). Must be within range [0, 1].}

\item{\code{stability.subsamples}}{integer Number of subsampling iterations (default=100)}

\item{\code{verbose}}{boolean Whether to provide verbose output (default=TRUE)}

\item{\code{cls}}{optional pre-calculated community result (may be useful for stability testing) (default: NULL)}

\item{\code{sr}}{optional pre-calculated subsampled community results (useful for stability testing) (default: NULL)}

\item{\code{...}}{extra parameters are passed to the specified community detection method}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible list containing identified communities (groups) and the full community detection result (result); The results are stored in $clusters$name slot in the conos object. Each such slot contains an object with elements: $results which stores the raw output of the community detection method, and $groups which is a factor on cells describing the resulting clustering. The later can be used, for instance, in plotting: con$plotGraph(groups=con$clusters$leiden$groups). If test.stability==TRUE, then the result object will also contain a $stability slot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{con <- Conos$new(small_panel.preprocessed, n.cores=1)
con$buildGraph(k=10, k.self=5, space='PCA', ncomps=10, n.odgenes=20, matching.method='mNN', 
    metric='angular', score.component.variance=TRUE, verbose=TRUE)
con$findCommunities(method = igraph::walktrap.community, steps=5)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotPanel"></a>}}
\if{latex}{\out{\hypertarget{method-plotPanel}{}}}
\subsection{Method \code{plotPanel()}}{
Plot panel of individual embeddings per sample with joint coloring
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$plotPanel(
  clustering = NULL,
  groups = NULL,
  colors = NULL,
  gene = NULL,
  use.local.clusters = FALSE,
  plot.theme = NULL,
  use.common.embedding = FALSE,
  embedding = NULL,
  adj.list = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{clustering}}{character Name of the clustering to use (see names(con$clusters)) for the value of the groups factor (default=NULL - if groups are not specified, the first clustering will be used)}

\item{\code{groups}}{a cell factor (a factor named with cell names) specifying clusters of cells to be compared (one against all). To compare two cell clusters against each other, simply pass a factor containing only two levels (default=NULL, see clustering)}

\item{\code{colors}}{a color factor (named with cell names) use for cell coloring}

\item{\code{gene}}{show expression of a gene}

\item{\code{use.local.clusters}}{boolean Whether clusters should be taken from the individual samples; otherwise joint clusters in the conos object will be used (see clustering) (default=FALSE).}

\item{\code{plot.theme}}{string Theme for the plot, passed to plotSamples() (default=NULL)}

\item{\code{use.common.embedding}}{boolean Whether a joint embedding in the conos object should be used (or embeddings determined for the individual samples) (default=FALSE)}

\item{\code{embedding}}{(default=NULL) If a character value is passed, it is interpreted as an embedding name (a name of a joint embedding in conos when use.commmon.embedding=TRUE, or a name of an embedding within the individual objects when use.common.embedding=FALSE).
If a matrix is passed, it is interpreted as an actual embedding (then first two columns are interpreted as x/y coordinates, row names must be cell names). If NULL, the default embedding will be used.}

\item{\code{adj.list}}{an optional list of additional ggplot2 directions to apply (default=NULL)}

\item{\code{...}}{Additional parameters passed to plotSamples(), plotEmbeddings(), sccore::embeddingPlot().}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
cowplot grid object with the panel of plots
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-embedGraph"></a>}}
\if{latex}{\out{\hypertarget{method-embedGraph}{}}}
\subsection{Method \code{embedGraph()}}{
Generate an embedding of a joint graph
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$embedGraph(
  method = "largeVis",
  embedding.name = method,
  M = 1,
  gamma = 1,
  alpha = 0.1,
  perplexity = NA,
  sgd_batches = 1e+08,
  seed = 1,
  verbose = TRUE,
  target.dims = 2,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{Embedding method (default='largeVis'). Currently 'largeVis' and 'UMAP' are supported.}

\item{\code{embedding.name}}{character Optional name of the name of the embedding set by user to store multiple embeddings (default: method name)}

\item{\code{M}}{numeric (largeVis) The number of negative edges to sample for each positive edge to be used (default=1)}

\item{\code{gamma}}{numeric (largeVis) The strength of the force pushing non-neighbor nodes apart (default=1)}

\item{\code{alpha}}{numeric (largeVis) Hyperparameter used in the default distance function, \eqn{1 / (1 + \alpha \dot ||y_i - y_j||^2)} (default=0.1).  The function relates the distance
between points in the low-dimensional projection to the likelihood that the two points are nearest neighbors. Increasing \eqn{\alpha} tends
to push nodes and their neighbors closer together; decreasing \eqn{\alpha} produces a broader distribution. Setting \eqn{\alpha} to zero
enables the alternative distance function. \eqn{\alpha} below zero is meaningless.}

\item{\code{perplexity}}{(largeVis) The perplexity passed to largeVis (default=NA)}

\item{\code{sgd_batches}}{(largeVis) The number of edges to process during SGD (default=1e8). Defaults to a value set based on the size of the dataset. If the parameter given is
between \code{0} and \code{1}, the default value will be multiplied by the parameter.}

\item{\code{seed}}{numeric Random seed for the largeVis algorithm (default=1)}

\item{\code{verbose}}{boolean Whether to provide verbose output (default=TRUE)}

\item{\code{target.dims}}{numeric Number of dimensions for the reduction (default=2). Higher dimensions can be used to generate embeddings for subsequent reductions by other methods, such as tSNE}

\item{\code{...}}{additional arguments, passed to UMAP embedding (run ?conos:::embedGraphUmap for more info)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotClusterStability"></a>}}
\if{latex}{\out{\hypertarget{method-plotClusterStability}{}}}
\subsection{Method \code{plotClusterStability()}}{
Plot cluster stability statistics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$plotClusterStability(clustering = NULL, what = "all")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{clustering}}{string Name of the clustering result to show (default=NULL)}

\item{\code{what}}{string Show a specific plot (ari - adjusted rand index, fjc - flat Jaccard, hjc - hierarchical Jaccard, dend - cluster dendrogram, all - everything except 'dend') (default='all')}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
cluster stability statistics
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotGraph"></a>}}
\if{latex}{\out{\hypertarget{method-plotGraph}{}}}
\subsection{Method \code{plotGraph()}}{
Plot joint graph
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$plotGraph(
  color.by = "cluster",
  clustering = NULL,
  embedding = NULL,
  groups = NULL,
  colors = NULL,
  gene = NULL,
  plot.theme = NULL,
  subset = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color.by}}{character A shortcut to color the plot by 'cluster' or by 'sample' (default: 'cluster'). If any other string is input, an error is thrown.}

\item{\code{clustering}}{a character name of the clustering to use (see names(con$clusters)) for the value of the groups factor (default: NULL - if groups are not specified, the first clustering will be used)}

\item{\code{embedding}}{A character name of an embedding, or a matrix of the actual embedding (rownames should correspond to cells, first to columns to x/y coordinates). If NULL (default: NULL), the latest generated embedding will be used}

\item{\code{groups}}{a cell factor (a factor named with cell names) specifying clusters of cells to be compared (one against all). To compare two cell clusters against each other, simply pass a factor containing only two levels (default: NULL, see clustering)}

\item{\code{colors}}{a color factor (named with cell names) use for cell coloring (default=NULL)}

\item{\code{gene}}{Show expression of a gene (default=NULL)}

\item{\code{plot.theme}}{Theme for the plot, passed to sccore::embeddingPlot() (default=NULL)}

\item{\code{subset}}{A subset of cells to show (default: NULL - shows all the cells)}

\item{\code{...}}{Additional parameters passed to sccore::embeddingPlot()}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 plot of joint graph
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-correctGenes"></a>}}
\if{latex}{\out{\hypertarget{method-correctGenes}{}}}
\subsection{Method \code{correctGenes()}}{
Smooth expression of genes to minimize the batch effect between samples
  Use diffusion of expression on graph with the equation dv = exp(-a * (v + b))
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$correctGenes(
  genes = NULL,
  n.od.genes = 500,
  fading = 10,
  fading.const = 0.5,
  max.iters = 15,
  tol = 0.005,
  name = "diffusion",
  verbose = TRUE,
  count.matrix = NULL,
  normalize = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genes}}{List of genes to be smooothed smoothing (default=NULL will smooth top n.od.genes overdispersed genes)}

\item{\code{n.od.genes}}{numeric If 'genes' is NULL, top n.od.genes of overdispersed genes are taken across all samples (default=500)}

\item{\code{fading}}{numeric Level of fading of expression change from distance on the graph (parameter 'a' of the equation) (default=10)}

\item{\code{fading.const}}{numeric Minimal penalty for each new edge during diffusion (parameter 'b' of the equation) (default=0.5)}

\item{\code{max.iters}}{numeric Maximal number of diffusion iterations (default=15)}

\item{\code{tol}}{numeric Tolerance after which the diffusion stops (default=5e-3)}

\item{\code{name}}{string Name to save the correction (default='diffusion')}

\item{\code{verbose}}{boolean Verbose mode (default=TRUE)}

\item{\code{count.matrix}}{Alternative gene count matrix to correct (rows: genes, columns: cells; has to be dense matrix). Default: joint count matrix for all datasets.}

\item{\code{normalize}}{boolean Whether to normalize values (default=TRUE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
smoothed expression of the input genes
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-propagateLabels"></a>}}
\if{latex}{\out{\hypertarget{method-propagateLabels}{}}}
\subsection{Method \code{propagateLabels()}}{
Estimate labeling distribution for each vertex, based on a partial labeling of the cells.
There are two methods used for the propagation to calculate the distribution of labels: "solver" and "diffusion".
* "diffusion" (default) will estimate the labeling distribution for each vertex, based on provided labels using a random walk.
* "solver" will propagate labels using the algorithm described by Zhu, Ghahramani, Lafferty (2003) <http://mlg.eng.cam.ac.uk/zoubin/papers/zgl.pdf>
Confidence values are then calculated by taking the maximum value from this distribution of labels, for each cell.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$propagateLabels(labels, method = "diffusion", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{labels}}{Input labels}

\item{\code{method}}{type of propagation. Either 'diffusion' or 'solver'. 'solver' gives better result
but has bad asymptotics, so is inappropriate for datasets > 20k cells. (default='diffusion')}

\item{\code{...}}{additional arguments for conos:::propagateLabels* functions}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list with three fields:
* labels = matrix with distribution of label probabilities for each vertex by rows.
* uncertainty = 1 - confidence values
* label.distribution = the distribution of labels calculated using either the methods "diffusion" or "solver"
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getClusterCountMatrices"></a>}}
\if{latex}{\out{\hypertarget{method-getClusterCountMatrices}{}}}
\subsection{Method \code{getClusterCountMatrices()}}{
Calculate pseudo-bulk expression matrices for clusters (by adding up, for each gene, all of the molecules detected for all cells in a given cluster in a given sample)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$getClusterCountMatrices(
  clustering = NULL,
  groups = NULL,
  common.genes = TRUE,
  omit.na.cells = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{clustering}}{string Name of the clustering to use}

\item{\code{groups}}{a factor on cells to use for coloring}

\item{\code{common.genes}}{boolean Whether to bring individual sample matrices to a common gene list (default=TRUE)}

\item{\code{omit.na.cells}}{boolean If set to FALSE, the resulting matrices will include a first column named 'NA' that will report total molecule counts for all of the cells that were not covered by the provided factor. (default=TRUE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list of per-sample uniform dense matrices with rows being genes, and columns being clusters
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDatasetPerCell"></a>}}
\if{latex}{\out{\hypertarget{method-getDatasetPerCell}{}}}
\subsection{Method \code{getDatasetPerCell()}}{
applies 'getCellNames()' on all samples
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$getDatasetPerCell()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list of cellnames for all samples
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{con <- Conos$new(small_panel.preprocessed, n.cores=1)
con$getDatasetPerCell()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getJointCountMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-getJointCountMatrix}{}}}
\subsection{Method \code{getJointCountMatrix()}}{
Retrieve joint count matrices
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$getJointCountMatrix(raw = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw}}{boolean If TRUE, return merged "raw" count matrices, using function getRawCountMatrix(). Otherwise, return the merged count matrices, using getCountMatrix(). (default=FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list of merged count matrices
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{con <- Conos$new(small_panel.preprocessed, n.cores=1)
con$getJointCountMatrix()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conos$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
