% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxgrob.R
\name{add_split}
\alias{add_split}
\title{Add a splitting box}
\usage{
add_split(prev_box, txt, coords = NULL, dist = 0.02)
}
\arguments{
\item{prev_box}{Previous node that the newly created split box will be aligned.}

\item{txt}{A vector of text labels for each nodes.}

\item{coords}{The horizontal coordinates of the boxes, see details.}

\item{dist}{Distance between previous node, including the distance between the
side node.}
}
\value{
A \code{consort.list} object.
}
\description{
This function will create a horizontally aligned nodes. The horizontal coordinate
will be automatically calculated if the coordinates not provided.
}
\details{
The `coords` will be used to set the horizontal coordinates of the nodes. The
`coords` should be within 0 and 1 to avoid the nodes is aligned outside of the
 final figure. If the `coords` is `NULL`, not given. The function will calculate
 the `coords`. If the the length of the `txt` is two, then a coordinates of
 0.35 and 0.65 will be used. Once the split box is added, all the following nodes
 will be split accordingly.
}
\examples{
txt1 <- "Population (n=300)"
txt1_side <- "Excluded (n=15): \n
              \u2022 MRI not collected (n=3)\n
              \u2022 Tissues not collected (n=4)\n
              \u2022 Other (n=8)"

node1 <- add_box(txt = txt1)

node3 <- add_side_box(node1, txt = txt1_side)    

node4 <- add_box(node3, txt = "Randomized (n=200)")

node1_sp <- add_split(node4, txt = c("Arm A (n=100)", "Arm B (n=100"))
side1_sp <- add_side_box(node1_sp, 
                         txt = c("Excluded (n=15):\n
                         \u2022 MRI not collected (n=3)\n
                         \u2022 Tissues not collected (n=4)\n
                         \u2022 Other (n=8)", 
                         "Excluded (n=15):\n
                         \u2022 MRI not collected (n=3)\n
                         \u2022 Tissues not collected (n=4)"))

node2_sp <- add_box(side1_sp, 
                    txt = c("Final analysis (n=100)",
                             "Final analysis (n=100"))#' 
node1
node3
node4
node1_sp
side1_sp
node2_sp


}
\seealso{
\code{\link{add_box}}, \code{\link{add_side_box}}
}
