% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.cstr_pipe}
\alias{.cstr_pipe}
\title{Insert a pipe between two calls}
\usage{
.cstr_pipe(x, y, pipe, one_liner)
}
\arguments{
\item{x}{A character vector. The code for the left hand side call.}

\item{y}{A character vector. The code for the right hand side call.}

\item{pipe}{A string. The pipe to use, \code{"plus"} is useful for ggplot code.}

\item{one_liner}{A boolean. Whether to paste \code{x}, the pipe and \code{y} together
on a same line (provided that \code{x} and \code{y} are strings and one liners themselves)}
}
\value{
A character vector
}
\description{
Exported for custom constructor design.
}
\examples{
.cstr_pipe("iris", "head(2)", pipe = "base", one_liner = FALSE)
.cstr_pipe("iris", "head(2)", pipe = "base", one_liner = TRUE)
}
