% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dict.R
\docType{class}
\name{Dict}
\alias{Dict}
\title{A Dict class}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Dict
}
\description{
The \code{Dict} resembles Python's dict type, and is implemented
as a specialized associative (or mapping) \code{\link[container]{Container}} thus
sharing all \code{\link[container]{Container}} methods with some of them being
overriden to account for the associative key-value pair semantic.
}
\section{Inherited methods}{

Inherits all methods from \code{\link[container]{Container}} but overrides the
internal initialize function and the following member functions:
\describe{
 \item{\code{add(key, value)}}{If \code{key} not yet in \code{Dict}, set
     \code{key} to \code{elem}, otherwise raise an error.}
 \item{\code{discard(key)}}{If \code{key} in \code{Dict}, remove it.}
 \item{\code{has(key)}}{TRUE if \code{key} in \code{Dict} else FALSE.}
 \item{\code{remove(key)}}{If \code{key} in \code{Dict}, remove it, otherwise
     raise an error.}
}
}

\section{Dict methods}{

\describe{
 \item{\code{get(key)}}{If \code{key} in \code{Dict}, return value, else
 throw key-error.}
 \item{\code{keys()}}{Return a character vector of all keys.}
 \item{\code{peek(key, default=NULL)}}{Return the value for \code{key} if
     \code{key} is in the \code{Dict}, else \code{default}.}
 \item{\code{pop(key)}}{If \code{key} in \code{Dict}, return a copy of its
     value and discard it afterwards.}
 \item{\code{popitem()}}{Remove and return an arbitrary (key, value) pair
 from the dictionary. \code{popitem()} is useful to destructively iterate
 over a \code{Dict}, as often used in set algorithms.}
 \item{\code{set(key, value, add=FALSE)}}{Like \code{add} but overwrites
     value if \code{key} is already in the \code{Dict}. If \code{key} not in
     \code{Dict}, an error is thrown unless \code{add} was set to
     \code{TRUE}}
 \item{\code{sort(decr=FALSE)}}{Sort values in dictionary according to keys.}
}
}

\examples{
ages <- Dict$new(c(Peter=24, Lisa=23, Bob=32))
ages$has("Peter")   # TRUE
ages$peek("Lisa")   # 23
ages$peek("Mike")   # NULL
ages$add("Mike", 18)
ages$peek("Mike")   # 18
ages$keys()
print(ages)

\dontrun{
Dict$new(list(Peter=20))$add("Peter", 22)         # key already in Dict
Dict$new(c(Peter=24, Lisa=23, Bob=32, Peter=20))  # Error: duplicated keys
}
}
\seealso{
\code{\link[container]{Container}}
}
\author{
Roman Pahl
}
\keyword{datasets}
