% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citation_matching.R
\name{match_citations_to_references}
\alias{match_citations_to_references}
\title{Match citations to references}
\usage{
match_citations_to_references(citations_df, references_df)
}
\arguments{
\item{citations_df}{Data frame with citation information, must include:
citation_id, citation_text, citation_text_clean, citation_type}

\item{references_df}{Data frame with parsed references from parse_references_section()}
}
\value{
Tibble with matched citations including columns:
\itemize{
\item citation_id: Citation identifier
\item citation_text: Original citation text
\item citation_text_clean: Cleaned citation text
\item citation_type: Type of citation
\item cite_author: Extracted first author from citation
\item cite_second_author: Second author (if present)
\item cite_year: Extracted year
\item cite_has_etal: Logical, contains "et al."
\item matched_ref_id: ID of matched reference
\item ref_full_text: Full text of matched reference
\item ref_authors: Authors from reference
\item ref_year: Year from reference
\item match_confidence: Quality of match (high, medium, low, no_match)
}
}
\description{
Matches in-text citations to entries in the reference list using author-year
matching with multiple disambiguation strategies.
}
\details{
Matching algorithm:
\enumerate{
\item Filter by exact year match
\item Match first author (exact, then fuzzy)
\item Disambiguate using second author or et al. heuristics
}

Match confidence levels include:
high (exact first author + year),
high_second_author (disambiguated with second author),
medium_multiple_matches, medium_fuzzy, medium_etal_heuristic (various medium confidence scenarios),
no_match_year, no_match_author, no_match_missing_info (no suitable reference found).
}
\examples{
\dontrun{
matched <- match_citations_to_references(citations_df, references_df)
table(matched$match_confidence)
}

}
